/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.domain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.cloudfoundry.client.lib.domain.CloudResource;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonGenerator;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonParser;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonProcessingException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.DeserializationContext;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonDeserializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonSerializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.SerializerProvider;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.annotate.JsonSerialize;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.TypeReference;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class CloudResources {
    private static final String HEX_CHARS = "0123456789ABCDEF";
    private List<CloudResource> resources;

    public CloudResources(Collection<? extends CloudResource> resources) {
        Assert.notNull(resources, "Resources must not be null");
        this.resources = new ArrayList<CloudResource>(resources);
    }

    public CloudResources(Iterator<? extends CloudResource> resources) {
        Assert.notNull(resources, "Resources must not be null");
        this.resources = new ArrayList<CloudResource>();
        while (resources.hasNext()) {
            this.resources.add(resources.next());
        }
    }

    public CloudResources(ApplicationArchive archive) throws IOException {
        Assert.notNull(archive, "Archive must not be null");
        this.resources = new ArrayList<CloudResource>();
        for (ApplicationArchive.Entry entry : archive.getEntries()) {
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            long size = entry.getSize();
            String sha1 = CloudResources.bytesToHex(entry.getSha1Digest());
            CloudResource resource = new CloudResource(name, size, sha1);
            this.resources.add(resource);
        }
    }

    public Set<String> getFilenames() {
        LinkedHashSet<String> filenames = new LinkedHashSet<String>();
        for (CloudResource resource : this.resources) {
            filenames.add(resource.getFilename());
        }
        return filenames;
    }

    public List<CloudResource> asList() {
        return Collections.unmodifiableList(this.resources);
    }

    private static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            hex.append(HEX_CHARS.charAt((b & 0xF0) >> 4)).append(HEX_CHARS.charAt(b & 0xF));
        }
        return hex.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Deserializer
    extends JsonDeserializer<CloudResources> {
        @Override
        public CloudResources deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            TypeReference<List<CloudResource>> ref = new TypeReference<List<CloudResource>>(){};
            return new CloudResources((Collection)jp.readValueAs(ref));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Serializer
    extends JsonSerializer<CloudResources> {
        @Override
        public void serialize(CloudResources value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.asList());
        }
    }
}

