/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.domain;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.domain.InstanceState;
import org.cloudfoundry.client.lib.util.CloudUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceStats {
    private int cores;
    private long diskQuota;
    private int fdsQuota;
    private String host;
    private String id;
    private long memQuota;
    private String name;
    private int port;
    private InstanceState state;
    private double uptime;
    private List<String> uris;
    private Usage usage;

    public InstanceStats(String id, Map<String, Object> attributes) {
        this.id = id;
        String instanceState = CloudUtil.parse(String.class, attributes.get("state"));
        this.state = InstanceState.valueOfWithDefault(instanceState);
        Map stats = CloudUtil.parse(Map.class, attributes.get("stats"));
        if (stats != null) {
            this.cores = CloudUtil.parse(Integer.class, stats.get("cores"));
            this.name = CloudUtil.parse(String.class, stats.get("name"));
            Map usageValue = CloudUtil.parse(Map.class, stats.get("usage"));
            if (usageValue != null) {
                this.usage = new Usage(usageValue);
            }
            this.diskQuota = CloudUtil.parse(Long.class, stats.get("disk_quota"));
            this.port = CloudUtil.parse(Integer.class, stats.get("port"));
            this.memQuota = CloudUtil.parse(Long.class, stats.get("mem_quota"));
            List statsValue = CloudUtil.parse(List.class, stats.get("uris"));
            if (statsValue != null) {
                this.uris = Collections.unmodifiableList(statsValue);
            }
            this.fdsQuota = CloudUtil.parse(Integer.class, stats.get("fds_quota"));
            this.host = CloudUtil.parse(String.class, stats.get("host"));
            this.uptime = CloudUtil.parse(Double.class, stats.get("uptime"));
        }
    }

    private static Date parseDate(String date) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss ZZZZZ").parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public int getCores() {
        return this.cores;
    }

    public long getDiskQuota() {
        return this.diskQuota;
    }

    public int getFdsQuota() {
        return this.fdsQuota;
    }

    public String getHost() {
        return this.host;
    }

    public String getId() {
        return this.id;
    }

    public long getMemQuota() {
        return this.memQuota;
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public InstanceState getState() {
        return this.state;
    }

    public double getUptime() {
        return this.uptime;
    }

    public List<String> getUris() {
        return this.uris;
    }

    public Usage getUsage() {
        return this.usage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Usage {
        private double cpu;
        private int disk;
        private int mem;
        private Date time;

        public Usage(Map<String, Object> attributes) {
            this.time = InstanceStats.parseDate(CloudUtil.parse(String.class, attributes.get("time")));
            this.cpu = CloudUtil.parse(Double.class, attributes.get("cpu"));
            this.disk = CloudUtil.parse(Integer.class, attributes.get("disk"));
            this.mem = CloudUtil.parse(Integer.class, attributes.get("mem"));
        }

        public double getCpu() {
            return this.cpu;
        }

        public int getDisk() {
            return this.disk;
        }

        public int getMem() {
            return this.mem;
        }

        public Date getTime() {
            return this.time;
        }
    }
}

