/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.domain;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.cloudfoundry.client.lib.domain.CloudResources;
import org.cloudfoundry.client.lib.io.DynamicZipInputStream;

public class UploadApplicationPayload {
    private ApplicationArchive archive;
    private ArrayList<DynamicZipInputStream.Entry> entriesToUpload;
    private int totalUncompressedSize;

    public UploadApplicationPayload(ApplicationArchive archive, CloudResources knownRemoteResources) throws IOException {
        this.archive = archive;
        this.totalUncompressedSize = 0;
        Set<String> matches = knownRemoteResources.getFilenames();
        this.entriesToUpload = new ArrayList();
        for (ApplicationArchive.Entry entry : archive.getEntries()) {
            if (!entry.isDirectory() && matches.contains(entry.getName())) continue;
            this.entriesToUpload.add(new DynamicZipInputStreamEntryAdapter(entry));
            this.totalUncompressedSize = (int)((long)this.totalUncompressedSize + entry.getSize());
        }
    }

    public ApplicationArchive getArchive() {
        return this.archive;
    }

    public int getTotalUncompressedSize() {
        return this.totalUncompressedSize;
    }

    public int getNumEntries() {
        return this.entriesToUpload.size();
    }

    public InputStream getInputStream() {
        return new DynamicZipInputStream(this.entriesToUpload);
    }

    private static class DynamicZipInputStreamEntryAdapter
    implements DynamicZipInputStream.Entry {
        private ApplicationArchive.Entry entry;

        public DynamicZipInputStreamEntryAdapter(ApplicationArchive.Entry entry) {
            this.entry = entry;
        }

        public String getName() {
            return this.entry.getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.entry.getInputStream();
        }
    }
}

