/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.util.Assert;

public abstract class DynamicInputStream
extends InputStream {
    private BufferedOutputStream outputStream = new BufferedOutputStream();
    private byte[] singleByte = new byte[1];

    public int read() throws IOException {
        int s = this.read(this.singleByte);
        if (s == 1) {
            return this.singleByte[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        return this.doRead(b, off, len, true);
    }

    private int doRead(byte[] b, int off, int len, boolean lastWriteWasSuccessful) throws IOException {
        if (this.outputStream.getAvailable() > 0) {
            return this.outputStream.read(b, off, len);
        }
        if (!lastWriteWasSuccessful) {
            return -1;
        }
        this.outputStream.clear();
        boolean writeSuccess = this.writeMoreData();
        return this.doRead(b, off, len, writeSuccess);
    }

    protected final OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected abstract boolean writeMoreData() throws IOException;

    private static class BufferedOutputStream
    extends ByteArrayOutputStream {
        private int offset;

        private BufferedOutputStream() {
        }

        public int getAvailable() {
            return this.count - this.offset;
        }

        public void clear() {
            this.count = 0;
            this.offset = 0;
        }

        public int read(byte[] b, int off, int len) {
            int length = Math.min(this.getAvailable(), len);
            Assert.state(length > 0, "No data available in buffer");
            System.arraycopy(this.buf, this.offset, b, off, length);
            this.offset += length;
            return length;
        }
    }
}

