/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.oauth2;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.util.JsonUtil;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordResourceDetails;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.web.client.RestTemplate;

public class OauthClient {
    private static final String AUTHORIZATION_HEADER_KEY = "Authorization";
    private URL authorizationUrl;
    private RestTemplate restTemplate;
    private OAuth2AccessToken token;
    private CloudCredentials credentials;

    public OauthClient(URL authorizationUrl, RestTemplate restTemplate) {
        this.authorizationUrl = authorizationUrl;
        this.restTemplate = restTemplate;
    }

    public void init(CloudCredentials credentials) {
        if (credentials != null) {
            this.credentials = credentials;
            this.token = credentials.getToken() != null ? credentials.getToken() : this.createToken(credentials.getEmail(), credentials.getPassword(), credentials.getClientId(), credentials.getClientSecret());
        }
    }

    public void clear() {
        this.token = null;
        this.credentials = null;
    }

    public OAuth2AccessToken getToken() {
        if (this.token == null) {
            return null;
        }
        if (this.token.getExpiresIn() < 50) {
            this.token = this.refreshToken(this.token, this.credentials.getEmail(), this.credentials.getPassword(), this.credentials.getClientId(), this.credentials.getClientSecret());
        }
        return this.token;
    }

    public String getAuthorizationHeader() {
        if (this.token != null) {
            return this.token.getTokenType() + " " + this.token.getValue();
        }
        return null;
    }

    private OAuth2AccessToken createToken(String username, String password, String clientId, String clientSecret) {
        OAuth2ProtectedResourceDetails resource = this.getResourceDetails(username, password, clientId, clientSecret);
        AccessTokenRequest request = this.createAccessTokenRequest(username, password);
        ResourceOwnerPasswordAccessTokenProvider provider = this.createResourceOwnerPasswordAccessTokenProvider();
        try {
            return provider.obtainAccessToken(resource, request);
        }
        catch (OAuth2AccessDeniedException oauthEx) {
            HttpStatus status = HttpStatus.valueOf(oauthEx.getHttpErrorCode());
            CloudFoundryException cfEx = new CloudFoundryException(status, oauthEx.getMessage());
            cfEx.setDescription(oauthEx.getSummary());
            throw cfEx;
        }
    }

    private OAuth2AccessToken refreshToken(OAuth2AccessToken currentToken, String username, String password, String clientId, String clientSecret) {
        OAuth2ProtectedResourceDetails resource = this.getResourceDetails(username, password, clientId, clientSecret);
        AccessTokenRequest request = this.createAccessTokenRequest(username, password);
        ResourceOwnerPasswordAccessTokenProvider provider = this.createResourceOwnerPasswordAccessTokenProvider();
        return provider.refreshAccessToken(resource, currentToken.getRefreshToken(), request);
    }

    public void changePassword(String oldPassword, String newPassword) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(AUTHORIZATION_HEADER_KEY, this.token.getTokenType() + " " + this.token.getValue());
        HttpEntity info = new HttpEntity(headers);
        ResponseEntity<String> response = this.restTemplate.exchange(this.authorizationUrl + "/userinfo", HttpMethod.GET, info, String.class, new Object[0]);
        Map<String, Object> responseMap = JsonUtil.convertJsonToMap((String)response.getBody());
        String userId = (String)responseMap.get("user_id");
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("schemas", new String[]{"urn:scim:schemas:core:1.0"});
        body.put("password", newPassword);
        body.put("oldPassword", oldPassword);
        HttpEntity httpEntity = new HttpEntity(body, headers);
        this.restTemplate.put(this.authorizationUrl + "/User/{id}/password", httpEntity, userId);
    }

    protected ResourceOwnerPasswordAccessTokenProvider createResourceOwnerPasswordAccessTokenProvider() {
        ResourceOwnerPasswordAccessTokenProvider resourceOwnerPasswordAccessTokenProvider = new ResourceOwnerPasswordAccessTokenProvider();
        resourceOwnerPasswordAccessTokenProvider.setRequestFactory(this.restTemplate.getRequestFactory());
        return resourceOwnerPasswordAccessTokenProvider;
    }

    private AccessTokenRequest createAccessTokenRequest(String username, String password) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("credentials", String.format("{\"username\":\"%s\",\"password\":\"%s\"}", username, password));
        DefaultAccessTokenRequest request = new DefaultAccessTokenRequest();
        request.setAll(parameters);
        return request;
    }

    private OAuth2ProtectedResourceDetails getResourceDetails(String username, String password, String clientId, String clientSecret) {
        ResourceOwnerPasswordResourceDetails resource = new ResourceOwnerPasswordResourceDetails();
        resource.setUsername(username);
        resource.setPassword(password);
        resource.setClientId(clientId);
        resource.setClientSecret(clientSecret);
        resource.setId(clientId);
        resource.setClientAuthenticationScheme(AuthenticationScheme.header);
        resource.setAccessTokenUri(this.authorizationUrl + "/oauth/token");
        return resource;
    }
}

