/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URL;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonEncoding;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonGenerator;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonParseException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonParser;
import org.cloudfoundry.client.lib.org.codehaus.jackson.ObjectCodec;
import org.cloudfoundry.client.lib.org.codehaus.jackson.Version;
import org.cloudfoundry.client.lib.org.codehaus.jackson.Versioned;
import org.cloudfoundry.client.lib.org.codehaus.jackson.impl.ByteSourceBootstrapper;
import org.cloudfoundry.client.lib.org.codehaus.jackson.impl.ReaderBasedParser;
import org.cloudfoundry.client.lib.org.codehaus.jackson.impl.Utf8Generator;
import org.cloudfoundry.client.lib.org.codehaus.jackson.impl.WriterBasedGenerator;
import org.cloudfoundry.client.lib.org.codehaus.jackson.io.IOContext;
import org.cloudfoundry.client.lib.org.codehaus.jackson.io.UTF8Writer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.sym.BytesToNameCanonicalizer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.sym.CharsToNameCanonicalizer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.util.BufferRecycler;
import org.cloudfoundry.client.lib.org.codehaus.jackson.util.VersionUtil;

public class JsonFactory
implements Versioned {
    static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    protected CharsToNameCanonicalizer _rootCharSymbols = CharsToNameCanonicalizer.createRoot();
    protected BytesToNameCanonicalizer _rootByteSymbols = BytesToNameCanonicalizer.createRoot();
    protected ObjectCodec _objectCodec;
    protected int _parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
    protected int _generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;

    public JsonFactory() {
        this(null);
    }

    public JsonFactory(ObjectCodec oc) {
        this._objectCodec = oc;
    }

    public Version version() {
        return VersionUtil.versionFor(Utf8Generator.class);
    }

    public final JsonFactory configure(JsonParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public JsonFactory enable(JsonParser.Feature f) {
        this._parserFeatures |= f.getMask();
        return this;
    }

    public JsonFactory disable(JsonParser.Feature f) {
        this._parserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(JsonParser.Feature f) {
        return (this._parserFeatures & f.getMask()) != 0;
    }

    public final void enableParserFeature(JsonParser.Feature f) {
        this.enable(f);
    }

    public final void disableParserFeature(JsonParser.Feature f) {
        this.disable(f);
    }

    public final void setParserFeature(JsonParser.Feature f, boolean state) {
        this.configure(f, state);
    }

    public final boolean isParserFeatureEnabled(JsonParser.Feature f) {
        return (this._parserFeatures & f.getMask()) != 0;
    }

    public final JsonFactory configure(JsonGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public JsonFactory enable(JsonGenerator.Feature f) {
        this._generatorFeatures |= f.getMask();
        return this;
    }

    public JsonFactory disable(JsonGenerator.Feature f) {
        this._generatorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(JsonGenerator.Feature f) {
        return (this._generatorFeatures & f.getMask()) != 0;
    }

    @Deprecated
    public final void enableGeneratorFeature(JsonGenerator.Feature f) {
        this.enable(f);
    }

    @Deprecated
    public final void disableGeneratorFeature(JsonGenerator.Feature f) {
        this.disable(f);
    }

    @Deprecated
    public final void setGeneratorFeature(JsonGenerator.Feature f, boolean state) {
        this.configure(f, state);
    }

    @Deprecated
    public final boolean isGeneratorFeatureEnabled(JsonGenerator.Feature f) {
        return this.isEnabled(f);
    }

    public JsonFactory setCodec(ObjectCodec oc) {
        this._objectCodec = oc;
        return this;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public JsonParser createJsonParser(File f) throws IOException, JsonParseException {
        return this._createJsonParser(new FileInputStream(f), this._createContext(f, true));
    }

    public JsonParser createJsonParser(URL url) throws IOException, JsonParseException {
        return this._createJsonParser(this._optimizedStreamFromURL(url), this._createContext(url, true));
    }

    public JsonParser createJsonParser(InputStream in) throws IOException, JsonParseException {
        return this._createJsonParser(in, this._createContext(in, false));
    }

    public JsonParser createJsonParser(Reader r) throws IOException, JsonParseException {
        return this._createJsonParser(r, this._createContext(r, false));
    }

    public JsonParser createJsonParser(byte[] data) throws IOException, JsonParseException {
        return this._createJsonParser(data, 0, data.length, this._createContext(data, true));
    }

    public JsonParser createJsonParser(byte[] data, int offset, int len) throws IOException, JsonParseException {
        return this._createJsonParser(data, offset, len, this._createContext(data, true));
    }

    public JsonParser createJsonParser(String content) throws IOException, JsonParseException {
        StringReader r = new StringReader(content);
        return this._createJsonParser(r, this._createContext(r, true));
    }

    public JsonGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        ctxt.setEncoding(enc);
        if (enc == JsonEncoding.UTF8) {
            return this._createUTF8JsonGenerator(out, ctxt);
        }
        return this._createJsonGenerator(this._createWriter(out, enc, ctxt), ctxt);
    }

    public JsonGenerator createJsonGenerator(Writer out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        return this._createJsonGenerator(out, ctxt);
    }

    public JsonGenerator createJsonGenerator(File f, JsonEncoding enc) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        if (enc == JsonEncoding.UTF8) {
            return this._createUTF8JsonGenerator(out, ctxt);
        }
        return this._createJsonGenerator(this._createWriter(out, enc, ctxt), ctxt);
    }

    protected IOContext _createContext(Object srcRef, boolean resourceManaged) {
        return new IOContext(this._getBufferRecycler(), srcRef, resourceManaged);
    }

    protected JsonParser _createJsonParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        return new ByteSourceBootstrapper(ctxt, in).constructParser(this._parserFeatures, this._objectCodec, this._rootByteSymbols, this._rootCharSymbols);
    }

    protected JsonParser _createJsonParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        return new ReaderBasedParser(ctxt, this._parserFeatures, r, this._objectCodec, this._rootCharSymbols.makeChild(this.isEnabled(JsonParser.Feature.CANONICALIZE_FIELD_NAMES), this.isEnabled(JsonParser.Feature.INTERN_FIELD_NAMES)));
    }

    protected JsonParser _createJsonParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        return new ByteSourceBootstrapper(ctxt, data, offset, len).constructParser(this._parserFeatures, this._objectCodec, this._rootByteSymbols, this._rootCharSymbols);
    }

    protected JsonGenerator _createJsonGenerator(Writer out, IOContext ctxt) throws IOException {
        return new WriterBasedGenerator(ctxt, this._generatorFeatures, this._objectCodec, out);
    }

    protected JsonGenerator _createUTF8JsonGenerator(OutputStream out, IOContext ctxt) throws IOException {
        return new Utf8Generator(ctxt, this._generatorFeatures, this._objectCodec, out);
    }

    public BufferRecycler _getBufferRecycler() {
        BufferRecycler br;
        SoftReference<BufferRecycler> ref = _recyclerRef.get();
        BufferRecycler bufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new BufferRecycler();
            _recyclerRef.set(new SoftReference<BufferRecycler>(br));
        }
        return br;
    }

    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == JsonEncoding.UTF8) {
            return new UTF8Writer(ctxt, out);
        }
        return new OutputStreamWriter(out, enc.getJavaName());
    }

    protected InputStream _optimizedStreamFromURL(URL url) throws IOException {
        String host;
        if ("file".equals(url.getProtocol()) && ((host = url.getHost()) == null || host.length() == 0)) {
            return new FileInputStream(url.getPath());
        }
        return url.openStream();
    }
}

