/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.io;

public final class NumberInput {
    static final long L_BILLION = 1000000000L;
    static final String MIN_LONG_STR_NO_SIGN = String.valueOf(Long.MIN_VALUE).substring(1);
    static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);

    public static final int parseInt(char[] digitChars, int offset, int len) {
        int num = digitChars[offset] - 48;
        if (++offset < (len += offset)) {
            num = num * 10 + (digitChars[offset] - 48);
            if (++offset < len) {
                num = num * 10 + (digitChars[offset] - 48);
                if (++offset < len) {
                    num = num * 10 + (digitChars[offset] - 48);
                    if (++offset < len) {
                        num = num * 10 + (digitChars[offset] - 48);
                        if (++offset < len) {
                            num = num * 10 + (digitChars[offset] - 48);
                            if (++offset < len) {
                                num = num * 10 + (digitChars[offset] - 48);
                                if (++offset < len) {
                                    num = num * 10 + (digitChars[offset] - 48);
                                    if (++offset < len) {
                                        num = num * 10 + (digitChars[offset] - 48);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return num;
    }

    public static final long parseLong(char[] digitChars, int offset, int len) {
        int len1 = len - 9;
        long val = (long)NumberInput.parseInt(digitChars, offset, len1) * 1000000000L;
        return val + (long)NumberInput.parseInt(digitChars, offset + len1, 9);
    }

    public static final boolean inLongRange(char[] digitChars, int offset, int len, boolean negative) {
        String cmpStr = negative ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int cmpLen = cmpStr.length();
        if (len < cmpLen) {
            return true;
        }
        if (len > cmpLen) {
            return false;
        }
        for (int i = 0; i < cmpLen; ++i) {
            if (digitChars[offset + i] <= cmpStr.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static final boolean inLongRange(String numberStr, boolean negative) {
        String cmpStr = negative ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int cmpLen = cmpStr.length();
        int actualLen = numberStr.length();
        if (actualLen < cmpLen) {
            return true;
        }
        if (actualLen > cmpLen) {
            return false;
        }
        for (int i = 0; i < cmpLen; ++i) {
            if (numberStr.charAt(i) <= cmpStr.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int parseAsInt(String input, int defaultValue) {
        char c;
        if (input == null) {
            return defaultValue;
        }
        int len = (input = input.trim()).length();
        if (len == 0) {
            return defaultValue;
        }
        int i = 0;
        if (i < len) {
            c = input.charAt(0);
            if (c == '+') {
                input = input.substring(1);
                len = input.length();
            } else if (c == '-') {
                ++i;
            }
        }
        while (i < len) {
            c = input.charAt(i);
            if (c > '9' || c < '0') {
                try {
                    double d = Double.parseDouble(input);
                    return (int)d;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long parseAsLong(String input, long defaultValue) {
        char c;
        if (input == null) {
            return defaultValue;
        }
        int len = (input = input.trim()).length();
        if (len == 0) {
            return defaultValue;
        }
        int i = 0;
        if (i < len) {
            c = input.charAt(0);
            if (c == '+') {
                input = input.substring(1);
                len = input.length();
            } else if (c == '-') {
                ++i;
            }
        }
        while (i < len) {
            c = input.charAt(i);
            if (c > '9' || c < '0') {
                try {
                    double d = Double.parseDouble(input);
                    return (long)d;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        try {
            return Long.parseLong(input);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double parseAsDouble(String input, double defaultValue) {
        if (input == null) {
            return defaultValue;
        }
        int len = (input = input.trim()).length();
        if (len == 0) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

