/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.io;

import org.cloudfoundry.client.lib.org.codehaus.jackson.io.JsonStringEncoder;

public class SerializedString {
    protected final String _value;
    protected volatile byte[] _quotedUTF8Ref;
    protected volatile byte[] _unquotedUTF8Ref;
    protected volatile char[] _quotedChars;

    public SerializedString(String v) {
        this._value = v;
    }

    public final String getValue() {
        return this._value;
    }

    public final int charLength() {
        return this._value.length();
    }

    public char[] asQuotedChars() {
        char[] result = this._quotedChars;
        if (result == null) {
            this._quotedChars = result = JsonStringEncoder.getInstance().quoteAsString(this._value);
        }
        return result;
    }

    public byte[] asUnquotedUTF8() {
        byte[] result = this._unquotedUTF8Ref;
        if (result == null) {
            this._unquotedUTF8Ref = result = JsonStringEncoder.getInstance().encodeAsUTF8(this._value);
        }
        return result;
    }

    public byte[] asQuotedUTF8() {
        byte[] result = this._quotedUTF8Ref;
        if (result == null) {
            this._quotedUTF8Ref = result = JsonStringEncoder.getInstance().quoteAsUTF8(this._value);
        }
        return result;
    }
}

