/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.map;

import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.AnnotationIntrospector;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.BeanDescription;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ClassIntrospector;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.MapperConfig;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.annotate.JsonSerialize;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.jsontype.SubtypeResolver;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.jsontype.impl.StdSubtypeResolver;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.type.ClassKey;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.util.StdDateFormat;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationConfig
implements MapperConfig<SerializationConfig> {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    protected ClassIntrospector<? extends BeanDescription> _classIntrospector;
    protected AnnotationIntrospector _annotationIntrospector;
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;
    protected DateFormat _dateFormat = StdDateFormat.instance;
    protected JsonSerialize.Inclusion _serializationInclusion = null;
    protected Class<?> _serializationView;
    protected HashMap<ClassKey, Class<?>> _mixInAnnotations;
    protected boolean _mixInAnnotationsShared;
    protected final TypeResolverBuilder<?> _typer;
    protected VisibilityChecker<?> _visibilityChecker;
    protected SubtypeResolver _subtypeResolver;

    public SerializationConfig(ClassIntrospector<? extends BeanDescription> intr, AnnotationIntrospector annIntr, VisibilityChecker<?> vc, SubtypeResolver subtypeResolver) {
        this._classIntrospector = intr;
        this._annotationIntrospector = annIntr;
        this._typer = null;
        this._visibilityChecker = vc;
        this._subtypeResolver = subtypeResolver;
    }

    protected SerializationConfig(SerializationConfig src, HashMap<ClassKey, Class<?>> mixins, TypeResolverBuilder<?> typer, VisibilityChecker<?> vc, SubtypeResolver subtypeResolver) {
        this._classIntrospector = src._classIntrospector;
        this._annotationIntrospector = src._annotationIntrospector;
        this._featureFlags = src._featureFlags;
        this._dateFormat = src._dateFormat;
        this._serializationInclusion = src._serializationInclusion;
        this._serializationView = src._serializationView;
        this._mixInAnnotations = mixins;
        this._typer = typer;
        this._visibilityChecker = vc;
        this._subtypeResolver = subtypeResolver;
    }

    @Override
    public void fromAnnotations(Class<?> cls) {
        JsonSerialize.Typing typing;
        AnnotatedClass ac = AnnotatedClass.construct(cls, this._annotationIntrospector, null);
        this._visibilityChecker = this._annotationIntrospector.findAutoDetectVisibility(ac, this._visibilityChecker);
        JsonSerialize.Inclusion incl = this._annotationIntrospector.findSerializationInclusion(ac, null);
        if (incl != this._serializationInclusion) {
            this.setSerializationInclusion(incl);
        }
        if ((typing = this._annotationIntrospector.findSerializationTyping(ac)) != null) {
            this.set(Feature.USE_STATIC_TYPING, typing == JsonSerialize.Typing.STATIC);
        }
    }

    @Override
    public SerializationConfig createUnshared(TypeResolverBuilder<?> typer, VisibilityChecker<?> vc, SubtypeResolver subtypeResolver) {
        HashMap<ClassKey, Class<?>> mixins = this._mixInAnnotations;
        this._mixInAnnotationsShared = true;
        return new SerializationConfig(this, mixins, typer, vc, subtypeResolver);
    }

    @Override
    public void setIntrospector(ClassIntrospector<? extends BeanDescription> i) {
        this._classIntrospector = i;
    }

    @Override
    public AnnotationIntrospector getAnnotationIntrospector() {
        if (this.isEnabled(Feature.USE_ANNOTATIONS)) {
            return this._annotationIntrospector;
        }
        return AnnotationIntrospector.nopInstance();
    }

    @Override
    public void setAnnotationIntrospector(AnnotationIntrospector ai) {
        this._annotationIntrospector = ai;
    }

    @Override
    public void setMixInAnnotations(Map<Class<?>, Class<?>> sourceMixins) {
        HashMap mixins = null;
        if (sourceMixins != null && sourceMixins.size() > 0) {
            mixins = new HashMap(sourceMixins.size());
            for (Map.Entry<Class<?>, Class<?>> en : sourceMixins.entrySet()) {
                mixins.put(new ClassKey(en.getKey()), en.getValue());
            }
        }
        this._mixInAnnotationsShared = false;
        this._mixInAnnotations = mixins;
    }

    @Override
    public void addMixInAnnotations(Class<?> target, Class<?> mixinSource) {
        if (this._mixInAnnotations == null || this._mixInAnnotationsShared) {
            this._mixInAnnotationsShared = false;
            this._mixInAnnotations = new HashMap();
        }
        this._mixInAnnotations.put(new ClassKey(target), mixinSource);
    }

    @Override
    public Class<?> findMixInClassFor(Class<?> cls) {
        return this._mixInAnnotations == null ? null : this._mixInAnnotations.get(new ClassKey(cls));
    }

    @Override
    public DateFormat getDateFormat() {
        return this._dateFormat;
    }

    @Override
    public void setDateFormat(DateFormat df) {
        this._dateFormat = df;
        this.set(Feature.WRITE_DATES_AS_TIMESTAMPS, df == null);
    }

    @Override
    public TypeResolverBuilder<?> getDefaultTyper(JavaType baseType) {
        return this._typer;
    }

    @Override
    public VisibilityChecker<?> getDefaultVisibilityChecker() {
        return this._visibilityChecker;
    }

    public void enable(Feature f) {
        this._featureFlags |= f.getMask();
    }

    public void disable(Feature f) {
        this._featureFlags &= ~f.getMask();
    }

    public void set(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
    }

    public final boolean isEnabled(Feature f) {
        return (this._featureFlags & f.getMask()) != 0;
    }

    public <T extends BeanDescription> T introspect(JavaType type) {
        return (T)this._classIntrospector.forSerialization(this, type, this);
    }

    public <T extends BeanDescription> T introspectClassAnnotations(Class<?> cls) {
        return (T)this._classIntrospector.forClassAnnotations(this, cls, this);
    }

    public <T extends BeanDescription> T introspectDirectClassAnnotations(Class<?> cls) {
        return (T)this._classIntrospector.forDirectClassAnnotations(this, cls, this);
    }

    @Override
    public SubtypeResolver getSubtypeResolver() {
        if (this._subtypeResolver == null) {
            this._subtypeResolver = new StdSubtypeResolver();
        }
        return this._subtypeResolver;
    }

    @Override
    public void setSubtypeResolver(SubtypeResolver r) {
        this._subtypeResolver = r;
    }

    public Class<?> getSerializationView() {
        return this._serializationView;
    }

    public JsonSerialize.Inclusion getSerializationInclusion() {
        if (this._serializationInclusion != null) {
            return this._serializationInclusion;
        }
        return this.isEnabled(Feature.WRITE_NULL_PROPERTIES) ? JsonSerialize.Inclusion.ALWAYS : JsonSerialize.Inclusion.NON_NULL;
    }

    public void setSerializationInclusion(JsonSerialize.Inclusion props) {
        this._serializationInclusion = props;
        if (props == JsonSerialize.Inclusion.NON_NULL) {
            this.disable(Feature.WRITE_NULL_PROPERTIES);
        } else {
            this.enable(Feature.WRITE_NULL_PROPERTIES);
        }
    }

    public void setSerializationView(Class<?> view) {
        this._serializationView = view;
    }

    public String toString() {
        return "[SerializationConfig: flags=0x" + Integer.toHexString(this._featureFlags) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        USE_ANNOTATIONS(true),
        AUTO_DETECT_GETTERS(true),
        AUTO_DETECT_IS_GETTERS(true),
        AUTO_DETECT_FIELDS(true),
        CAN_OVERRIDE_ACCESS_MODIFIERS(true),
        WRITE_NULL_PROPERTIES(true),
        USE_STATIC_TYPING(false),
        WRAP_ROOT_VALUE(false),
        FAIL_ON_EMPTY_BEANS(true),
        DEFAULT_VIEW_INCLUSION(true),
        CLOSE_CLOSEABLE(false),
        WRITE_DATES_AS_TIMESTAMPS(true),
        WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS(false),
        WRITE_ENUMS_USING_TO_STRING(false),
        WRITE_NULL_MAP_VALUES(true),
        INDENT_OUTPUT(false);

        final boolean _defaultState;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

