/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.util.EnumMap;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonParser;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonProcessingException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonToken;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.DeserializationContext;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonDeserializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.TypeDeserializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser.EnumResolver;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser.StdDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumMapDeserializer
extends StdDeserializer<EnumMap<?, ?>> {
    final EnumResolver<?> _enumResolver;
    final JsonDeserializer<Object> _valueDeserializer;

    public EnumMapDeserializer(EnumResolver<?> enumRes, JsonDeserializer<Object> valueDes) {
        super(EnumMap.class);
        this._enumResolver = enumRes;
        this._valueDeserializer = valueDes;
    }

    @Override
    public EnumMap<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw ctxt.mappingException(EnumMap.class);
        }
        EnumMap<?, ?> result = this.constructMap();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            Object key = this._enumResolver.findEnum(fieldName);
            if (key == null) {
                throw ctxt.weirdStringException(this._enumResolver.getEnumClass(), "value not one of declared Enum instance names");
            }
            JsonToken t = jp.nextToken();
            Object value = t == JsonToken.VALUE_NULL ? null : this._valueDeserializer.deserialize(jp, ctxt);
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    private EnumMap<?, ?> constructMap() {
        Class<?> enumCls = this._enumResolver.getEnumClass();
        return new EnumMap(enumCls);
    }
}

