/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.util.EnumSet;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonParser;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonProcessingException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonToken;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.DeserializationContext;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.TypeDeserializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser.EnumDeserializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser.EnumResolver;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser.StdDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumSetDeserializer
extends StdDeserializer<EnumSet<?>> {
    final Class<Enum> _enumClass;
    final EnumDeserializer _enumDeserializer;

    public EnumSetDeserializer(EnumResolver enumRes) {
        super(EnumSet.class);
        this._enumDeserializer = new EnumDeserializer(enumRes);
        this._enumClass = enumRes.getEnumClass();
    }

    @Override
    public EnumSet<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t;
        if (jp.getCurrentToken() != JsonToken.START_ARRAY) {
            throw ctxt.mappingException(EnumSet.class);
        }
        EnumSet result = this.constructSet();
        while ((t = jp.nextToken()) != JsonToken.END_ARRAY) {
            if (t == JsonToken.VALUE_NULL) {
                throw ctxt.mappingException(this._enumClass);
            }
            Object value = this._enumDeserializer.deserialize(jp, ctxt);
            result.add(value);
        }
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromArray(jp, ctxt);
    }

    private EnumSet constructSet() {
        return EnumSet.noneOf(this._enumClass);
    }
}

