/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonParser;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonProcessingException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonToken;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.DeserializationConfig;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.DeserializationContext;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.DeserializerProvider;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonDeserializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonMappingException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.KeyDeserializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ResolvableDeserializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.TypeDeserializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser.ContainerDeserializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser.Creator;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser.CreatorContainer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser.PropertyValueBuffer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.util.ArrayBuilders;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class MapDeserializer
extends ContainerDeserializer<Map<Object, Object>>
implements ResolvableDeserializer {
    final JavaType _mapType;
    final KeyDeserializer _keyDeserializer;
    final JsonDeserializer<Object> _valueDeserializer;
    final TypeDeserializer _valueTypeDeserializer;
    final Constructor<Map<Object, Object>> _defaultCtor;
    protected Creator.PropertyBased _propertyBasedCreator;
    protected HashSet<String> _ignorableProperties;

    public MapDeserializer(JavaType mapType, Constructor<Map<Object, Object>> defCtor, KeyDeserializer keyDeser, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser) {
        super(Map.class);
        this._mapType = mapType;
        this._defaultCtor = defCtor;
        this._keyDeserializer = keyDeser;
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
    }

    public void setCreators(CreatorContainer creators) {
        this._propertyBasedCreator = creators.propertyBasedCreator();
    }

    public void setIgnorableProperties(String[] ignorable) {
        this._ignorableProperties = ignorable == null || ignorable.length == 0 ? null : ArrayBuilders.arrayToSet(ignorable);
    }

    @Override
    public JavaType getContentType() {
        return this._mapType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public void resolve(DeserializationConfig config, DeserializerProvider provider) throws JsonMappingException {
        if (this._propertyBasedCreator != null) {
            HashMap<JavaType, JsonDeserializer<Object>> seen = new HashMap<JavaType, JsonDeserializer<Object>>();
            for (SettableBeanProperty prop : this._propertyBasedCreator.properties()) {
                prop.setValueDeserializer(this.findDeserializer(config, provider, prop.getType(), prop.getPropertyName(), seen));
            }
        }
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Map<Object, Object> result;
        JsonToken t = jp.getCurrentToken();
        if (t != JsonToken.START_OBJECT && t != JsonToken.FIELD_NAME) {
            throw ctxt.mappingException(this.getMapClass());
        }
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingCreator(jp, ctxt);
        }
        if (this._defaultCtor == null) {
            throw ctxt.instantiationException(this.getMapClass(), "No default constructor found");
        }
        try {
            result = this._defaultCtor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw ctxt.instantiationException(this.getMapClass(), e);
        }
        this._readAndBind(jp, ctxt, result);
        return result;
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt, Map<Object, Object> result) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t != JsonToken.START_OBJECT && t != JsonToken.FIELD_NAME) {
            throw ctxt.mappingException(this.getMapClass());
        }
        this._readAndBind(jp, ctxt, result);
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    public final Class<?> getMapClass() {
        return this._mapType.getRawClass();
    }

    @Override
    public JavaType getValueType() {
        return this._mapType;
    }

    protected final void _readAndBind(JsonParser jp, DeserializationContext ctxt, Map<Object, Object> result) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        KeyDeserializer keyDes = this._keyDeserializer;
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        while (t == JsonToken.FIELD_NAME) {
            String fieldName = jp.getCurrentName();
            String key = keyDes == null ? fieldName : keyDes.deserializeKey(fieldName, ctxt);
            t = jp.nextToken();
            if (this._ignorableProperties != null && this._ignorableProperties.contains(fieldName)) {
                jp.skipChildren();
            } else {
                Object value = t == JsonToken.VALUE_NULL ? null : (typeDeser == null ? valueDes.deserialize(jp, ctxt) : valueDes.deserializeWithType(jp, ctxt, typeDeser));
                result.put(key, value);
            }
            t = jp.nextToken();
        }
    }

    public Map<Object, Object> _deserializeUsingCreator(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Creator.PropertyBased creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(jp, ctxt);
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        while (t == JsonToken.FIELD_NAME) {
            String propName = jp.getCurrentName();
            t = jp.nextToken();
            if (this._ignorableProperties != null && this._ignorableProperties.contains(propName)) {
                jp.skipChildren();
            } else {
                SettableBeanProperty prop = creator.findCreatorProperty(propName);
                if (prop != null) {
                    Object value = prop.deserialize(jp, ctxt);
                    if (buffer.assignParameter(prop.getCreatorIndex(), value)) {
                        jp.nextToken();
                        Map result = (Map)creator.build(buffer);
                        this._readAndBind(jp, ctxt, result);
                        return result;
                    }
                } else {
                    String key;
                    String fieldName = jp.getCurrentName();
                    String string = key = this._keyDeserializer == null ? fieldName : this._keyDeserializer.deserializeKey(fieldName, ctxt);
                    Object value = t == JsonToken.VALUE_NULL ? null : (typeDeser == null ? valueDes.deserialize(jp, ctxt) : valueDes.deserializeWithType(jp, ctxt, typeDeser));
                    buffer.bufferMapProperty(key, value);
                }
            }
            t = jp.nextToken();
        }
        return (Map)creator.build(buffer);
    }
}

