/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.map.jsontype.impl;

import java.io.IOException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonParser;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonProcessingException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonToken;
import org.cloudfoundry.client.lib.org.codehaus.jackson.annotate.JsonTypeInfo;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.DeserializationContext;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonDeserializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.jsontype.TypeIdResolver;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.jsontype.impl.TypeDeserializerBase;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.JavaType;

public class AsArrayTypeDeserializer
extends TypeDeserializerBase {
    public AsArrayTypeDeserializer(JavaType bt, TypeIdResolver idRes) {
        super(bt, idRes);
    }

    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_ARRAY;
    }

    public Object deserializeTypedFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(jp, ctxt);
    }

    public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(jp, ctxt);
    }

    public Object deserializeTypedFromScalar(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(jp, ctxt);
    }

    public Object deserializeTypedFromAny(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(jp, ctxt);
    }

    private final Object _deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonDeserializer<Object> deser = this._findDeserializer(ctxt, this._locateTypeId(jp, ctxt));
        Object value = deser.deserialize(jp, ctxt);
        if (jp.nextToken() != JsonToken.END_ARRAY) {
            throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "expected closing END_ARRAY after type information and deserialized value");
        }
        return value;
    }

    protected final String _locateTypeId(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() != JsonToken.START_ARRAY) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "need JSON Array to contain As.WRAPPER_ARRAY type information for class " + this.baseTypeName());
        }
        if (jp.nextToken() != JsonToken.VALUE_STRING) {
            throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "need JSON String that contains type id (for subtype of " + this.baseTypeName() + ")");
        }
        String result = jp.getText();
        jp.nextToken();
        return result;
    }
}

