/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.map.jsontype.impl;

import java.io.IOException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonParser;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonProcessingException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonToken;
import org.cloudfoundry.client.lib.org.codehaus.jackson.annotate.JsonTypeInfo;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.DeserializationContext;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonDeserializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.jsontype.TypeIdResolver;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.jsontype.impl.TypeDeserializerBase;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.JavaType;

public class AsWrapperTypeDeserializer
extends TypeDeserializerBase {
    public AsWrapperTypeDeserializer(JavaType bt, TypeIdResolver idRes) {
        super(bt, idRes);
    }

    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_OBJECT;
    }

    public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(jp, ctxt);
    }

    public Object deserializeTypedFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(jp, ctxt);
    }

    public Object deserializeTypedFromScalar(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(jp, ctxt);
    }

    public Object deserializeTypedFromAny(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(jp, ctxt);
    }

    private final Object _deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_OBJECT, "need JSON Object to contain As.WRAPPER_OBJECT type information for class " + this.baseTypeName());
        }
        if (jp.nextToken() != JsonToken.FIELD_NAME) {
            throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "need JSON String that contains type id (for subtype of " + this.baseTypeName() + ")");
        }
        JsonDeserializer<Object> deser = this._findDeserializer(ctxt, jp.getText());
        jp.nextToken();
        Object value = deser.deserialize(jp, ctxt);
        if (jp.nextToken() != JsonToken.END_OBJECT) {
            throw ctxt.wrongTokenException(jp, JsonToken.END_OBJECT, "expected closing END_OBJECT after type information and deserialized value");
        }
        return value;
    }
}

