/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.map.ser;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonGenerator;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonMappingException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonSerializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.SerializerProvider;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.TypeSerializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanPropertyWriter {
    protected final Method _accessorMethod;
    protected final Field _field;
    protected final String _name;
    protected final JavaType _cfgSerializationType;
    protected final JsonSerializer<Object> _serializer;
    protected final boolean _suppressNulls;
    protected final Object _suppressableValue;
    protected Class<?>[] _includeInViews;
    protected TypeSerializer _typeSerializer;
    protected JavaType _nonTrivialBaseType;

    public BeanPropertyWriter(String name, JsonSerializer<Object> ser, TypeSerializer typeSer, JavaType serType, Method acc, Field f, boolean suppressNulls, Object suppressableValue) {
        this._name = name;
        this._serializer = ser;
        this._typeSerializer = typeSer;
        this._cfgSerializationType = serType;
        this._accessorMethod = acc;
        this._field = f;
        this._suppressNulls = suppressNulls;
        this._suppressableValue = suppressableValue;
    }

    protected BeanPropertyWriter(BeanPropertyWriter base) {
        this._name = base._name;
        this._serializer = base._serializer;
        this._typeSerializer = base._typeSerializer;
        this._cfgSerializationType = base._cfgSerializationType;
        this._accessorMethod = base._accessorMethod;
        this._field = base._field;
        this._suppressNulls = base._suppressNulls;
        this._suppressableValue = base._suppressableValue;
    }

    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new BeanPropertyWriter(this._name, ser, this._typeSerializer, this._cfgSerializationType, this._accessorMethod, this._field, this._suppressNulls, this._suppressableValue);
    }

    public void setViews(Class<?>[] views) {
        this._includeInViews = views;
    }

    public void setNonTrivialBaseType(JavaType t) {
        this._nonTrivialBaseType = t;
    }

    public final String getName() {
        return this._name;
    }

    public boolean hasSerializer() {
        return this._serializer != null;
    }

    protected JsonSerializer<Object> getSerializer() {
        return this._serializer;
    }

    public JavaType getSerializationType() {
        return this._cfgSerializationType;
    }

    public Class<?> getRawSerializationType() {
        return this._cfgSerializationType == null ? null : this._cfgSerializationType.getRawClass();
    }

    public Class<?> getPropertyType() {
        if (this._accessorMethod != null) {
            return this._accessorMethod.getReturnType();
        }
        return this._field.getType();
    }

    public Type getGenericPropertyType() {
        if (this._accessorMethod != null) {
            return this._accessorMethod.getGenericReturnType();
        }
        return this._field.getGenericType();
    }

    public Class<?>[] getViews() {
        return this._includeInViews;
    }

    public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        Object value = this.get(bean);
        if (value == null) {
            if (!this._suppressNulls) {
                jgen.writeFieldName(this._name);
                prov.getNullValueSerializer().serialize(value, jgen, prov);
            }
            return;
        }
        if (value == bean) {
            this._reportSelfReference(bean);
        }
        if (this._suppressableValue != null && this._suppressableValue.equals(value)) {
            return;
        }
        JsonSerializer<Object> ser = this._serializer;
        if (ser == null) {
            Class<?> cls = value.getClass();
            if (this._nonTrivialBaseType != null) {
                JavaType t = this._nonTrivialBaseType.forcedNarrowBy(cls);
                ser = prov.findValueSerializer(t);
            } else {
                ser = prov.findValueSerializer(cls);
            }
        }
        jgen.writeFieldName(this._name);
        if (this._typeSerializer == null) {
            ser.serialize(value, jgen, prov);
        } else {
            ser.serializeWithType(value, jgen, prov, this._typeSerializer);
        }
    }

    public final Object get(Object bean) throws Exception {
        if (this._accessorMethod != null) {
            return this._accessorMethod.invoke(bean, new Object[0]);
        }
        return this._field.get(bean);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        sb.append("property '").append(this.getName()).append("' (");
        if (this._accessorMethod != null) {
            sb.append("via method ").append(this._accessorMethod.getDeclaringClass().getName()).append("#").append(this._accessorMethod.getName());
        } else {
            sb.append("field \"").append(this._field.getDeclaringClass().getName()).append("#").append(this._field.getName());
        }
        sb.append(')');
        return sb.toString();
    }

    protected void _reportSelfReference(Object bean) throws JsonMappingException {
        throw new JsonMappingException("Direct self-reference leading to cycle");
    }
}

