/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonGenerationException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonGenerator;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonNode;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonMappingException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonSerializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ResolvableSerializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.SerializerProvider;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.TypeSerializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ser.AnyGetterWriter;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ser.ContainerSerializerBase;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ser.SerializerBase;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.type.TypeFactory;
import org.cloudfoundry.client.lib.org.codehaus.jackson.node.ObjectNode;
import org.cloudfoundry.client.lib.org.codehaus.jackson.schema.JsonSchema;
import org.cloudfoundry.client.lib.org.codehaus.jackson.schema.SchemaAware;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializer
extends SerializerBase<Object>
implements ResolvableSerializer,
SchemaAware {
    protected static final BeanPropertyWriter[] NO_PROPS = new BeanPropertyWriter[0];
    protected final Class<?> _class;
    protected final BeanPropertyWriter[] _props;
    protected final BeanPropertyWriter[] _filteredProps;
    protected AnyGetterWriter _anyGetterWriter;

    public BeanSerializer(Class<?> type, BeanPropertyWriter[] writers) {
        this(type, writers, null);
    }

    public BeanSerializer(Class<?> type, BeanPropertyWriter[] props, BeanPropertyWriter[] filteredProps) {
        super(type, false);
        this._props = props;
        this._class = type;
        this._filteredProps = filteredProps;
    }

    public BeanSerializer(Class<?> type, Collection<BeanPropertyWriter> props) {
        this(type, props.toArray(new BeanPropertyWriter[props.size()]));
    }

    public static BeanSerializer createDummy(Class<?> forType) {
        return new BeanSerializer(forType, NO_PROPS);
    }

    public BeanSerializer withFiltered(BeanPropertyWriter[] filtered) {
        if (filtered == null) {
            return this;
        }
        return new BeanSerializer(this._class, this._props, filtered);
    }

    public void setAnyGetter(AnyGetterWriter agw) {
        this._anyGetterWriter = agw;
    }

    @Override
    public final void serialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        this.serializeFields(bean, jgen, provider);
        jgen.writeEndObject();
    }

    @Override
    public final void serializeWithType(Object bean, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForObject(bean, jgen);
        this.serializeFields(bean, jgen, provider);
        typeSer.writeTypeSuffixForObject(bean, jgen);
    }

    protected void serializeFields(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        int i;
        BeanPropertyWriter[] props = this._filteredProps != null && provider.getSerializationView() != null ? this._filteredProps : this._props;
        try {
            for (BeanPropertyWriter prop : props) {
                if (prop == null) continue;
                prop.serializeAsField(bean, jgen, provider);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(bean, jgen, provider);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow((Throwable)e, bean, props[i].getName());
        }
        catch (StackOverflowError e) {
            JsonMappingException mapE = new JsonMappingException("Infinite recursion (StackOverflowError)");
            mapE.prependPath(new JsonMappingException.Reference(bean, props[i].getName()));
            throw mapE;
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        ObjectNode o = this.createSchemaNode("object", true);
        ObjectNode propertiesNode = o.objectNode();
        for (int i = 0; i < this._props.length; ++i) {
            JsonSerializer<Object> ser;
            BeanPropertyWriter prop = this._props[i];
            Type hint = prop.getRawSerializationType();
            if (hint == null) {
                hint = prop.getGenericPropertyType();
            }
            if ((ser = prop.getSerializer()) == null) {
                Class<?> serType = prop.getRawSerializationType();
                if (serType == null) {
                    serType = prop.getPropertyType();
                }
                ser = provider.findValueSerializer(serType);
            }
            JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, hint) : JsonSchema.getDefaultSchemaNode();
            o.put("items", schemaNode);
            propertiesNode.put(prop.getName(), schemaNode);
        }
        o.put("properties", propertiesNode);
        return o;
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        for (BeanPropertyWriter prop : this._props) {
            TypeSerializer typeSer;
            if (prop.hasSerializer()) continue;
            JavaType type = prop.getSerializationType();
            if (type == null && !(type = TypeFactory.type(prop.getGenericPropertyType())).isFinal()) {
                if (!type.isContainerType() && type.containedTypeCount() <= 0) continue;
                prop.setNonTrivialBaseType(type);
                continue;
            }
            JsonSerializer<Object> ser = provider.findValueSerializer(type);
            if (type.isContainerType() && (typeSer = (TypeSerializer)type.getContentType().getTypeHandler()) != null && ser instanceof ContainerSerializerBase) {
                ContainerSerializerBase<?> ser2 = ((ContainerSerializerBase)ser).withValueTypeSerializer(typeSer);
                ser = ser2;
            }
            this._props[i] = prop.withSerializer(ser);
        }
        if (this._anyGetterWriter != null) {
            this._anyGetterWriter.resolve(provider);
        }
    }

    public String toString() {
        return "BeanSerializer for " + this._class.getName();
    }
}

