/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonGenerationException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonGenerator;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonNode;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.AnnotationIntrospector;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonMappingException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.SerializationConfig;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.SerializerProvider;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ser.ScalarSerializerBase;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.type.TypeFactory;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.util.EnumValues;
import org.cloudfoundry.client.lib.org.codehaus.jackson.node.ArrayNode;
import org.cloudfoundry.client.lib.org.codehaus.jackson.node.ObjectNode;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class EnumSerializer
extends ScalarSerializerBase<Enum<?>> {
    protected final EnumValues _values;

    public EnumSerializer(EnumValues v) {
        super(Enum.class, false);
        this._values = v;
    }

    @Deprecated
    public static EnumSerializer construct(Class<Enum<?>> enumClass, AnnotationIntrospector intr) {
        return new EnumSerializer(EnumValues.construct(enumClass, intr));
    }

    public static EnumSerializer construct(Class<Enum<?>> enumClass, SerializationConfig config, BasicBeanDescription beanDesc) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        EnumValues v = config.isEnabled(SerializationConfig.Feature.WRITE_ENUMS_USING_TO_STRING) ? EnumValues.constructFromToString(enumClass, intr) : EnumValues.constructFromName(enumClass, intr);
        return new EnumSerializer(v);
    }

    @Override
    public void serialize(Enum<?> en, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeString(this._values.valueFor(en));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        JavaType type;
        ObjectNode objectNode = this.createSchemaNode("string", true);
        if (typeHint != null && (type = TypeFactory.type(typeHint)).isEnumType()) {
            ArrayNode enumNode = objectNode.putArray("enum");
            for (String value : this._values.values()) {
                enumNode.add(value);
            }
        }
        return objectNode;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }
}

