/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonGenerationException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonGenerator;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonNode;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonMappingException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonSerializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ResolvableSerializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.SerializationConfig;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.SerializerProvider;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.TypeSerializer;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ser.ContainerSerializerBase;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.type.TypeFactory;
import org.cloudfoundry.client.lib.org.codehaus.jackson.node.ObjectNode;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class MapSerializer
extends ContainerSerializerBase<Map<?, ?>>
implements ResolvableSerializer {
    public static final MapSerializer instance = new MapSerializer();
    protected final HashSet<String> _ignoredEntries;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _valueType;
    protected JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;

    protected MapSerializer() {
        this(null, null, false, null);
    }

    protected MapSerializer(HashSet<String> ignoredEntries, JavaType valueType, boolean valueTypeIsStatic, TypeSerializer vts) {
        super(Map.class, false);
        this._ignoredEntries = ignoredEntries;
        this._valueType = valueType;
        this._valueTypeIsStatic = valueTypeIsStatic;
        this._valueTypeSerializer = vts;
    }

    @Override
    public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
        MapSerializer ms = new MapSerializer(this._ignoredEntries, this._valueType, this._valueTypeIsStatic, vts);
        if (this._valueSerializer != null) {
            ms._valueSerializer = this._valueSerializer;
        }
        return ms;
    }

    public static MapSerializer construct(String[] ignoredList, JavaType mapType, boolean staticValueType, TypeSerializer vts) {
        JavaType valueType;
        HashSet<String> ignoredEntries = MapSerializer.toSet(ignoredList);
        JavaType javaType = valueType = mapType == null ? TypeFactory.type(Object.class) : mapType.getContentType();
        if (!staticValueType) {
            boolean bl = staticValueType = valueType != null && valueType.isFinal();
        }
        if (!staticValueType && ignoredEntries == null && vts == null) {
            return instance;
        }
        return new MapSerializer(ignoredEntries, valueType, staticValueType, vts);
    }

    private static HashSet<String> toSet(String[] ignoredEntries) {
        if (ignoredEntries == null || ignoredEntries.length == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>(ignoredEntries.length);
        for (String prop : ignoredEntries) {
            result.add(prop);
        }
        return result;
    }

    @Override
    public void serialize(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        if (!value.isEmpty()) {
            if (this._valueSerializer != null) {
                this.serializeFieldsUsing(value, jgen, provider, this._valueSerializer);
            } else {
                this.serializeFields(value, jgen, provider);
            }
        }
        jgen.writeEndObject();
    }

    @Override
    public void serializeWithType(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForObject(value, jgen);
        if (!value.isEmpty()) {
            if (this._valueSerializer != null) {
                this.serializeFieldsUsing(value, jgen, provider, this._valueSerializer);
            } else {
                this.serializeFields(value, jgen, provider);
            }
        }
        typeSer.writeTypeSuffixForObject(value, jgen);
    }

    protected void serializeFields(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedFields(value, jgen, provider);
            return;
        }
        JsonSerializer<Object> keySerializer = provider.getKeySerializer();
        JsonSerializer<Object> prevValueSerializer = null;
        Class<?> prevValueClass = null;
        HashSet<String> ignored = this._ignoredEntries;
        boolean skipNulls = !provider.isEnabled(SerializationConfig.Feature.WRITE_NULL_MAP_VALUES);
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            JsonSerializer<Object> currSerializer;
            Object valueElem = entry.getValue();
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                provider.getNullKeySerializer().serialize(null, jgen, provider);
            } else {
                if (skipNulls && valueElem == null || ignored != null && ignored.contains(keyElem)) continue;
                keySerializer.serialize(keyElem, jgen, provider);
            }
            if (valueElem == null) {
                provider.getNullValueSerializer().serialize(null, jgen, provider);
                continue;
            }
            Class<?> cc = valueElem.getClass();
            if (cc == prevValueClass) {
                currSerializer = prevValueSerializer;
            } else {
                prevValueSerializer = currSerializer = provider.findValueSerializer(cc);
                prevValueClass = cc;
            }
            try {
                currSerializer.serialize(valueElem, jgen, provider);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow((Throwable)e, value, keyDesc);
            }
        }
    }

    protected void serializeFieldsUsing(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
        JsonSerializer<Object> keySerializer = provider.getKeySerializer();
        HashSet<String> ignored = this._ignoredEntries;
        TypeSerializer typeSer = this._valueTypeSerializer;
        boolean skipNulls = !provider.isEnabled(SerializationConfig.Feature.WRITE_NULL_MAP_VALUES);
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            Object valueElem = entry.getValue();
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                provider.getNullKeySerializer().serialize(null, jgen, provider);
            } else {
                if (skipNulls && valueElem == null || ignored != null && ignored.contains(keyElem)) continue;
                keySerializer.serialize(keyElem, jgen, provider);
            }
            if (valueElem == null) {
                provider.getNullValueSerializer().serialize(null, jgen, provider);
                continue;
            }
            try {
                if (typeSer == null) {
                    ser.serialize(valueElem, jgen, provider);
                    continue;
                }
                ser.serializeWithType(valueElem, jgen, provider, typeSer);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow((Throwable)e, value, keyDesc);
            }
        }
    }

    protected void serializeTypedFields(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        JsonSerializer<Object> keySerializer = provider.getKeySerializer();
        JsonSerializer<Object> prevValueSerializer = null;
        Class<?> prevValueClass = null;
        HashSet<String> ignored = this._ignoredEntries;
        boolean skipNulls = !provider.isEnabled(SerializationConfig.Feature.WRITE_NULL_MAP_VALUES);
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            JsonSerializer<Object> currSerializer;
            Object valueElem = entry.getValue();
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                provider.getNullKeySerializer().serialize(null, jgen, provider);
            } else {
                if (skipNulls && valueElem == null || ignored != null && ignored.contains(keyElem)) continue;
                keySerializer.serialize(keyElem, jgen, provider);
            }
            if (valueElem == null) {
                provider.getNullValueSerializer().serialize(null, jgen, provider);
                continue;
            }
            Class<?> cc = valueElem.getClass();
            if (cc == prevValueClass) {
                currSerializer = prevValueSerializer;
            } else {
                prevValueSerializer = currSerializer = provider.findValueSerializer(cc);
                prevValueClass = cc;
            }
            try {
                currSerializer.serializeWithType(valueElem, jgen, provider, this._valueTypeSerializer);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow((Throwable)e, value, keyDesc);
            }
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("object", true);
        return o;
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this._valueTypeIsStatic) {
            this._valueSerializer = provider.findValueSerializer(this._valueType);
        }
    }
}

