/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.org.codehaus.jackson.map.type;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.type.ArrayType;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.type.CollectionType;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.type.HierarchicType;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.type.MapType;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.type.SimpleType;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.type.TypeBindings;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.type.TypeParser;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.JavaType;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFactory {
    public static final TypeFactory instance = new TypeFactory();
    protected final TypeParser _parser = new TypeParser(this);

    private TypeFactory() {
    }

    public static JavaType type(Type t) {
        return instance._fromType(t, null);
    }

    public static JavaType type(Type type, Class<?> context) {
        return TypeFactory.type(type, new TypeBindings(context));
    }

    public static JavaType type(Type type, TypeBindings bindings) {
        return instance._fromType(type, bindings);
    }

    public static JavaType type(TypeReference<?> ref) {
        return TypeFactory.type(ref.getType());
    }

    public static JavaType arrayType(Class<?> elementType) {
        return TypeFactory.arrayType(TypeFactory.type(elementType));
    }

    public static JavaType arrayType(JavaType elementType) {
        return ArrayType.construct(elementType);
    }

    public static JavaType collectionType(Class<? extends Collection> collectionType, Class<?> elementType) {
        return TypeFactory.collectionType(collectionType, TypeFactory.type(elementType));
    }

    public static JavaType collectionType(Class<? extends Collection> collectionType, JavaType elementType) {
        return CollectionType.construct(collectionType, elementType);
    }

    public static JavaType mapType(Class<? extends Map> mapType, Class<?> keyType, Class<?> valueType) {
        return TypeFactory.mapType(mapType, TypeFactory.type(keyType), TypeFactory.type(valueType));
    }

    public static JavaType mapType(Class<? extends Map> mapType, JavaType keyType, JavaType valueType) {
        return MapType.construct(mapType, keyType, valueType);
    }

    public static JavaType parametricType(Class<?> parametrized, Class<?> ... parameterClasses) {
        int len = parameterClasses.length;
        JavaType[] pt = new JavaType[len];
        for (int i = 0; i < len; ++i) {
            pt[i] = instance._fromClass(parameterClasses[i], null);
        }
        return TypeFactory.parametricType(parametrized, pt);
    }

    public static JavaType parametricType(Class<?> parametrized, JavaType ... parameterTypes) {
        if (parametrized.isArray()) {
            if (parameterTypes.length != 1) {
                throw new IllegalArgumentException("Need exactly 1 parameter type for arrays (" + parametrized.getName() + ")");
            }
            return ArrayType.construct(parameterTypes[0]);
        }
        if (Map.class.isAssignableFrom(parametrized)) {
            if (parameterTypes.length != 2) {
                throw new IllegalArgumentException("Need exactly 2 parameter types for Map types (" + parametrized.getName() + ")");
            }
            return MapType.construct(parametrized, parameterTypes[0], parameterTypes[1]);
        }
        if (Collection.class.isAssignableFrom(parametrized)) {
            if (parameterTypes.length != 1) {
                throw new IllegalArgumentException("Need exactly 1 parameter type for Collection types (" + parametrized.getName() + ")");
            }
            return CollectionType.construct(parametrized, parameterTypes[0]);
        }
        return TypeFactory._constructSimple(parametrized, parameterTypes);
    }

    public static JavaType fromCanonical(String canonical) throws IllegalArgumentException {
        return TypeFactory.instance._parser.parse(canonical);
    }

    public static JavaType specialize(JavaType baseType, Class<?> subclass) {
        if (baseType instanceof SimpleType && (subclass.isArray() || Map.class.isAssignableFrom(subclass) || Collection.class.isAssignableFrom(subclass))) {
            if (!baseType.getRawClass().isAssignableFrom(subclass)) {
                throw new IllegalArgumentException("Class " + subclass.getClass().getName() + " not subtype of " + baseType);
            }
            JavaType subtype = instance._fromClass(subclass, new TypeBindings(baseType.getRawClass()));
            Object h = baseType.getValueHandler();
            if (h != null) {
                subtype.setValueHandler(h);
            }
            if ((h = baseType.getTypeHandler()) != null) {
                subtype.setTypeHandler(h);
            }
            return subtype;
        }
        return baseType.narrowBy(subclass);
    }

    public static JavaType fastSimpleType(Class<?> cls) {
        return new SimpleType(cls, null, null);
    }

    public static JavaType[] findParameterTypes(Class<?> clz, Class<?> expType) {
        HierarchicType subType = TypeFactory._findSuperTypeChain(clz, expType);
        if (subType == null) {
            throw new IllegalArgumentException("Class " + clz.getName() + " is not a subtype of " + expType.getName());
        }
        HierarchicType superType = subType;
        while (superType.getSuperType() != null) {
            superType = superType.getSuperType();
        }
        if (!superType.isGeneric()) {
            return null;
        }
        ParameterizedType pt = superType.asGeneric();
        Type[] actualTypes = pt.getActualTypeArguments();
        JavaType[] resultTypes = new JavaType[actualTypes.length];
        TypeBindings bindings = new TypeBindings(clz);
        for (Type t : actualTypes) {
            resultTypes[i] = t instanceof TypeVariable ? TypeFactory._resolveVariableViaSubTypes(superType.getSubType(), ((TypeVariable)t).getName(), bindings) : instance._fromType(t, bindings);
        }
        return resultTypes;
    }

    public static JavaType[] findParameterTypes(JavaType type, Class<?> expType) {
        Class<?> raw = type.getRawClass();
        if (raw == expType) {
            int count = type.containedTypeCount();
            if (count == 0) {
                return null;
            }
            JavaType[] result = new JavaType[count];
            for (int i = 0; i < count; ++i) {
                result[i] = type.containedType(i);
            }
            return result;
        }
        return TypeFactory.findParameterTypes(raw, expType);
    }

    @Deprecated
    public static JavaType fromClass(Class<?> clz) {
        return instance._fromClass(clz, null);
    }

    @Deprecated
    public static JavaType fromTypeReference(TypeReference<?> ref) {
        return TypeFactory.type(ref.getType());
    }

    @Deprecated
    public static JavaType fromType(Type type) {
        return instance._fromType(type, null);
    }

    protected JavaType _fromClass(Class<?> clz, TypeBindings context) {
        if (clz.isArray()) {
            return ArrayType.construct(this._fromType(clz.getComponentType(), null));
        }
        if (clz.isEnum()) {
            return new SimpleType(clz);
        }
        if (Map.class.isAssignableFrom(clz)) {
            return this._mapType(clz);
        }
        if (Collection.class.isAssignableFrom(clz)) {
            return this._collectionType(clz);
        }
        return new SimpleType(clz);
    }

    protected JavaType _fromParameterizedClass(Class<?> clz, List<JavaType> paramTypes) {
        if (clz.isArray()) {
            return ArrayType.construct(this._fromType(clz.getComponentType(), null));
        }
        if (clz.isEnum()) {
            return new SimpleType(clz);
        }
        if (Map.class.isAssignableFrom(clz)) {
            if (paramTypes.size() > 0) {
                JavaType keyType = paramTypes.get(0);
                JavaType contentType = paramTypes.size() >= 2 ? paramTypes.get(1) : this._unknownType();
                return MapType.construct(clz, keyType, contentType);
            }
            return this._mapType(clz);
        }
        if (Collection.class.isAssignableFrom(clz)) {
            if (paramTypes.size() >= 1) {
                return CollectionType.construct(clz, paramTypes.get(0));
            }
            return this._collectionType(clz);
        }
        if (paramTypes.size() == 0) {
            return new SimpleType(clz);
        }
        JavaType[] pt = paramTypes.toArray(new JavaType[paramTypes.size()]);
        return TypeFactory._constructSimple(clz, pt);
    }

    public JavaType _fromType(Type type, TypeBindings context) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (context == null) {
                context = new TypeBindings(cls);
            }
            return this._fromClass(cls, context);
        }
        if (type instanceof ParameterizedType) {
            return this._fromParamType((ParameterizedType)type, context);
        }
        if (type instanceof GenericArrayType) {
            return this._fromArrayType((GenericArrayType)type, context);
        }
        if (type instanceof TypeVariable) {
            return this._fromVariable((TypeVariable)type, context);
        }
        if (type instanceof WildcardType) {
            return this._fromWildcard((WildcardType)type, context);
        }
        throw new IllegalArgumentException("Unrecognized Type: " + type.toString());
    }

    protected JavaType _fromParamType(ParameterizedType type, TypeBindings context) {
        int len;
        Class rawType = (Class)type.getRawType();
        Type[] args = type.getActualTypeArguments();
        if (Map.class.isAssignableFrom(rawType)) {
            JavaType keyType = this._fromType(args[0], context);
            JavaType valueType = this._fromType(args[1], context);
            return MapType.construct(rawType, keyType, valueType);
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            JavaType valueType = this._fromType(args[0], context);
            return CollectionType.construct(rawType, valueType);
        }
        int n = len = args == null ? 0 : args.length;
        if (len == 0) {
            return new SimpleType(rawType);
        }
        JavaType[] pt = new JavaType[len];
        for (int i = 0; i < len; ++i) {
            pt[i] = this._fromType(args[i], context);
        }
        return TypeFactory._constructSimple(rawType, pt);
    }

    protected static SimpleType _constructSimple(Class<?> rawType, JavaType[] parameterTypes) {
        TypeVariable<Class<?>>[] typeVars = rawType.getTypeParameters();
        if (typeVars.length != parameterTypes.length) {
            throw new IllegalArgumentException("Parameter type mismatch for " + rawType.getName() + ": expected " + typeVars.length + " parameters, was given " + parameterTypes.length);
        }
        String[] names = new String[typeVars.length];
        int len = typeVars.length;
        for (int i = 0; i < len; ++i) {
            names[i] = typeVars[i].getName();
        }
        return new SimpleType(rawType, names, parameterTypes);
    }

    protected JavaType _fromArrayType(GenericArrayType type, TypeBindings context) {
        JavaType compType = this._fromType(type.getGenericComponentType(), context);
        return ArrayType.construct(compType);
    }

    protected JavaType _fromVariable(TypeVariable<?> type, TypeBindings context) {
        if (context == null) {
            return this._unknownType();
        }
        String name = type.getName();
        JavaType actualType = context.findType(name);
        if (actualType != null) {
            return actualType;
        }
        Type[] bounds = type.getBounds();
        context._addPlaceholder(name);
        return this._fromType(bounds[0], context);
    }

    protected JavaType _fromWildcard(WildcardType type, TypeBindings context) {
        return this._fromType(type.getUpperBounds()[0], context);
    }

    private JavaType _mapType(Class<?> rawClass) {
        JavaType[] typeParams = TypeFactory.findParameterTypes(rawClass, Map.class);
        if (typeParams == null) {
            return MapType.construct(rawClass, this._unknownType(), this._unknownType());
        }
        if (typeParams.length != 2) {
            throw new IllegalArgumentException("Strange Map type " + rawClass.getName() + ": can not determine type parameters");
        }
        return MapType.construct(rawClass, typeParams[0], typeParams[1]);
    }

    private JavaType _collectionType(Class<?> rawClass) {
        JavaType[] typeParams = TypeFactory.findParameterTypes(rawClass, Collection.class);
        if (typeParams == null) {
            return CollectionType.construct(rawClass, this._unknownType());
        }
        if (typeParams.length != 1) {
            throw new IllegalArgumentException("Strange Collection type " + rawClass.getName() + ": can not determine type parameters");
        }
        return CollectionType.construct(rawClass, typeParams[0]);
    }

    protected static JavaType _resolveVariableViaSubTypes(HierarchicType leafType, String variableName, TypeBindings bindings) {
        if (leafType != null && leafType.isGeneric()) {
            TypeVariable<Class<?>>[] typeVariables = leafType.getRawClass().getTypeParameters();
            int len = typeVariables.length;
            for (int i = 0; i < len; ++i) {
                TypeVariable<Class<?>> tv = typeVariables[i];
                if (!variableName.equals(tv.getName())) continue;
                Type type = leafType.asGeneric().getActualTypeArguments()[i];
                if (type instanceof TypeVariable) {
                    return TypeFactory._resolveVariableViaSubTypes(leafType.getSubType(), ((TypeVariable)type).getName(), bindings);
                }
                return instance._fromType(type, bindings);
            }
        }
        return instance._unknownType();
    }

    protected JavaType _unknownType() {
        return this._fromClass(Object.class, null);
    }

    protected static HierarchicType _findSuperTypeChain(Class<?> subtype, Class<?> supertype) {
        if (supertype.isInterface()) {
            return TypeFactory._findSuperInterfaceChain(subtype, supertype);
        }
        return TypeFactory._findSuperClassChain(subtype, supertype);
    }

    protected static HierarchicType _findSuperClassChain(Type currentType, Class<?> target) {
        HierarchicType sup;
        HierarchicType current = new HierarchicType(currentType);
        Class<?> raw = current.getRawClass();
        if (raw == target) {
            return current;
        }
        Type parent = raw.getGenericSuperclass();
        if (parent != null && (sup = TypeFactory._findSuperClassChain(parent, target)) != null) {
            sup.setSubType(current);
            current.setSuperType(sup);
            return current;
        }
        return null;
    }

    protected static HierarchicType _findSuperInterfaceChain(Type currentType, Class<?> target) {
        HierarchicType sup;
        Type parent;
        HierarchicType current = new HierarchicType(currentType);
        Class<?> raw = current.getRawClass();
        if (raw == target) {
            return current;
        }
        Type[] parents = raw.getGenericInterfaces();
        if (parents != null) {
            for (Type parent2 : parents) {
                HierarchicType sup2 = TypeFactory._findSuperInterfaceChain(parent2, target);
                if (sup2 == null) continue;
                sup2.setSubType(current);
                current.setSuperType(sup2);
                return current;
            }
        }
        if ((parent = raw.getGenericSuperclass()) != null && (sup = TypeFactory._findSuperInterfaceChain(parent, target)) != null) {
            sup.setSubType(current);
            current.setSuperType(sup);
            return current;
        }
        return null;
    }
}

