/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.rest;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.cloudfoundry.client.lib.ApplicationLogListener;
import org.cloudfoundry.client.lib.ClientHttpResponseCallback;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.RestLogCallback;
import org.cloudfoundry.client.lib.StartingInfo;
import org.cloudfoundry.client.lib.StreamingLogToken;
import org.cloudfoundry.client.lib.UploadStatusCallback;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.cloudfoundry.client.lib.domain.ApplicationLog;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudDomain;
import org.cloudfoundry.client.lib.domain.CloudInfo;
import org.cloudfoundry.client.lib.domain.CloudOrganization;
import org.cloudfoundry.client.lib.domain.CloudRoute;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.CloudServiceBroker;
import org.cloudfoundry.client.lib.domain.CloudServiceOffering;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.domain.CloudStack;
import org.cloudfoundry.client.lib.domain.CrashesInfo;
import org.cloudfoundry.client.lib.domain.InstancesInfo;
import org.cloudfoundry.client.lib.domain.Staging;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.web.client.ResponseErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CloudControllerClient {
    public void setResponseErrorHandler(ResponseErrorHandler var1);

    public URL getCloudControllerUrl();

    public CloudInfo getInfo();

    public List<CloudSpace> getSpaces();

    public List<CloudOrganization> getOrganizations();

    public OAuth2AccessToken login();

    public void logout();

    public void register(String var1, String var2);

    public void updatePassword(String var1);

    public void updatePassword(CloudCredentials var1, String var2);

    public void unregister();

    public List<CloudService> getServices();

    public void createService(CloudService var1);

    public void createUserProvidedService(CloudService var1, Map<String, Object> var2);

    public CloudService getService(String var1);

    public void deleteService(String var1);

    public void deleteAllServices();

    public List<CloudServiceOffering> getServiceOfferings();

    public List<CloudServiceBroker> getServiceBrokers();

    public List<CloudApplication> getApplications();

    public CloudApplication getApplication(String var1);

    public CloudApplication getApplication(UUID var1);

    public ApplicationStats getApplicationStats(String var1);

    public void createApplication(String var1, Staging var2, Integer var3, List<String> var4, List<String> var5);

    public void createApplication(String var1, Staging var2, Integer var3, Integer var4, List<String> var5, List<String> var6);

    public void uploadApplication(String var1, File var2, UploadStatusCallback var3) throws IOException;

    public void uploadApplication(String var1, ApplicationArchive var2, UploadStatusCallback var3) throws IOException;

    public StartingInfo startApplication(String var1);

    public void debugApplication(String var1, CloudApplication.DebugMode var2);

    public void stopApplication(String var1);

    public StartingInfo restartApplication(String var1);

    public void deleteApplication(String var1);

    public void deleteAllApplications();

    public void updateApplicationDiskQuota(String var1, int var2);

    public void updateApplicationMemory(String var1, int var2);

    public void updateApplicationInstances(String var1, int var2);

    public void updateApplicationServices(String var1, List<String> var2);

    public void updateApplicationStaging(String var1, Staging var2);

    public void updateApplicationUris(String var1, List<String> var2);

    public void updateApplicationEnv(String var1, Map<String, String> var2);

    public void updateApplicationEnv(String var1, List<String> var2);

    public Map<String, String> getLogs(String var1);

    public StreamingLogToken streamLogs(String var1, ApplicationLogListener var2);

    public List<ApplicationLog> getRecentLogs(String var1);

    public Map<String, String> getCrashLogs(String var1);

    public String getFile(String var1, int var2, String var3, int var4, int var5);

    public void openFile(String var1, int var2, String var3, ClientHttpResponseCallback var4);

    public void bindService(String var1, String var2);

    public void unbindService(String var1, String var2);

    public InstancesInfo getApplicationInstances(String var1);

    public InstancesInfo getApplicationInstances(CloudApplication var1);

    public CrashesInfo getCrashes(String var1);

    public void rename(String var1, String var2);

    public String getStagingLogs(StartingInfo var1, int var2);

    public List<CloudStack> getStacks();

    public CloudStack getStack(String var1);

    public List<CloudDomain> getDomainsForOrg();

    public List<CloudDomain> getDomains();

    public List<CloudDomain> getPrivateDomains();

    public List<CloudDomain> getSharedDomains();

    public CloudDomain getDefaultDomain();

    public void addDomain(String var1);

    public void deleteDomain(String var1);

    public void removeDomain(String var1);

    public List<CloudRoute> getRoutes(String var1);

    public void addRoute(String var1, String var2);

    public void deleteRoute(String var1, String var2);

    public void registerRestLogListener(RestLogCallback var1);

    public void unRegisterRestLogListener(RestLogCallback var1);
}

