/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.oauth2.OauthClient;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ObjectMapper;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.TypeReference;
import org.cloudfoundry.client.lib.rest.CloudControllerClient;
import org.cloudfoundry.client.lib.rest.CloudControllerClientImpl;
import org.cloudfoundry.client.lib.rest.LoggregatorClient;
import org.cloudfoundry.client.lib.util.RestUtil;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudControllerClientFactory {
    private final RestUtil restUtil;
    private final RestTemplate restTemplate;
    private OauthClient oauthClient;
    private final HttpProxyConfiguration httpProxyConfiguration;
    private final boolean trustSelfSignedCerts;
    private ObjectMapper objectMapper;
    private final Map<URL, Map<String, Object>> infoCache = new HashMap<URL, Map<String, Object>>();

    public CloudControllerClientFactory(HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
        this.restUtil = new RestUtil();
        this.restTemplate = this.restUtil.createRestTemplate(httpProxyConfiguration, trustSelfSignedCerts);
        this.httpProxyConfiguration = httpProxyConfiguration;
        this.trustSelfSignedCerts = trustSelfSignedCerts;
        this.objectMapper = new ObjectMapper();
    }

    public CloudControllerClient newCloudController(URL cloudControllerUrl, CloudCredentials cloudCredentials, CloudSpace sessionSpace) {
        this.createOauthClient(cloudControllerUrl);
        LoggregatorClient loggregatorClient = new LoggregatorClient(this.trustSelfSignedCerts);
        return new CloudControllerClientImpl(cloudControllerUrl, this.restTemplate, this.oauthClient, loggregatorClient, cloudCredentials, sessionSpace);
    }

    public CloudControllerClient newCloudController(URL cloudControllerUrl, CloudCredentials cloudCredentials, String orgName, String spaceName) {
        this.createOauthClient(cloudControllerUrl);
        LoggregatorClient loggregatorClient = new LoggregatorClient(this.trustSelfSignedCerts);
        return new CloudControllerClientImpl(cloudControllerUrl, this.restTemplate, this.oauthClient, loggregatorClient, cloudCredentials, orgName, spaceName);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public OauthClient getOauthClient() {
        return this.oauthClient;
    }

    private void createOauthClient(URL cloudControllerUrl) {
        Map<String, Object> infoMap = this.getInfoMap(cloudControllerUrl);
        URL authorizationEndpoint = this.getAuthorizationEndpoint(infoMap, cloudControllerUrl);
        this.oauthClient = this.restUtil.createOauthClient(authorizationEndpoint, this.httpProxyConfiguration, this.trustSelfSignedCerts);
    }

    private Map<String, Object> getInfoMap(URL cloudControllerUrl) {
        if (this.infoCache.containsKey(cloudControllerUrl)) {
            return this.infoCache.get(cloudControllerUrl);
        }
        String s = this.restTemplate.getForObject(cloudControllerUrl + "/info", String.class, new Object[0]);
        try {
            return (Map)this.objectMapper.readValue(s, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting /info from Cloud Controller", e);
        }
    }

    private URL getAuthorizationEndpoint(Map<String, Object> infoMap, URL cloudControllerUrl) {
        String authEndPoint = (String)infoMap.get("authorization_endpoint");
        try {
            return new URL(authEndPoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Error creating auth endpoint URL for endpoint " + authEndPoint, e);
        }
    }
}

