/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.rest;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.zip.ZipFile;
import javax.websocket.ClientEndpointConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.client.lib.ApplicationLogListener;
import org.cloudfoundry.client.lib.ClientHttpResponseCallback;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.RestLogCallback;
import org.cloudfoundry.client.lib.StartingInfo;
import org.cloudfoundry.client.lib.StreamingLogToken;
import org.cloudfoundry.client.lib.UploadStatusCallback;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.cloudfoundry.client.lib.archive.DirectoryApplicationArchive;
import org.cloudfoundry.client.lib.archive.ZipApplicationArchive;
import org.cloudfoundry.client.lib.domain.ApplicationLog;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudDomain;
import org.cloudfoundry.client.lib.domain.CloudInfo;
import org.cloudfoundry.client.lib.domain.CloudOrganization;
import org.cloudfoundry.client.lib.domain.CloudResource;
import org.cloudfoundry.client.lib.domain.CloudResources;
import org.cloudfoundry.client.lib.domain.CloudRoute;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.CloudServiceBroker;
import org.cloudfoundry.client.lib.domain.CloudServiceOffering;
import org.cloudfoundry.client.lib.domain.CloudServicePlan;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.domain.CloudStack;
import org.cloudfoundry.client.lib.domain.CrashInfo;
import org.cloudfoundry.client.lib.domain.CrashesInfo;
import org.cloudfoundry.client.lib.domain.InstanceState;
import org.cloudfoundry.client.lib.domain.InstanceStats;
import org.cloudfoundry.client.lib.domain.InstancesInfo;
import org.cloudfoundry.client.lib.domain.Staging;
import org.cloudfoundry.client.lib.domain.UploadApplicationPayload;
import org.cloudfoundry.client.lib.oauth2.OauthClient;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ObjectMapper;
import org.cloudfoundry.client.lib.rest.CloudControllerClient;
import org.cloudfoundry.client.lib.rest.LoggingRestTemplate;
import org.cloudfoundry.client.lib.rest.LoggregatorClient;
import org.cloudfoundry.client.lib.util.CloudEntityResourceMapper;
import org.cloudfoundry.client.lib.util.CloudUtil;
import org.cloudfoundry.client.lib.util.JsonUtil;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import sun.misc.BASE64Decoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudControllerClientImpl
implements CloudControllerClient {
    private static final String AUTHORIZATION_HEADER_KEY = "Authorization";
    private static final String PROXY_USER_HEADER_KEY = "Proxy-User";
    private static final String LOGS_LOCATION = "logs";
    private static final int JOB_POLLING_PERIOD = 5000;
    private OauthClient oauthClient;
    private CloudSpace sessionSpace;
    private CloudEntityResourceMapper resourceMapper = new CloudEntityResourceMapper();
    private RestTemplate restTemplate;
    private URL cloudControllerUrl;
    private LoggregatorClient loggregatorClient;
    protected CloudCredentials cloudCredentials;
    private final Log logger = LogFactory.getLog(this.getClass().getName());

    protected CloudControllerClientImpl() {
    }

    public CloudControllerClientImpl(URL cloudControllerUrl, RestTemplate restTemplate, OauthClient oauthClient, LoggregatorClient loggregatorClient, CloudCredentials cloudCredentials, CloudSpace sessionSpace) {
        this.initialize(cloudControllerUrl, restTemplate, oauthClient, loggregatorClient, cloudCredentials);
        this.sessionSpace = sessionSpace;
    }

    public CloudControllerClientImpl(URL cloudControllerUrl, RestTemplate restTemplate, OauthClient oauthClient, LoggregatorClient loggregatorClient, CloudCredentials cloudCredentials, String orgName, String spaceName) {
        CloudControllerClientImpl tempClient = new CloudControllerClientImpl(cloudControllerUrl, restTemplate, oauthClient, loggregatorClient, cloudCredentials, null);
        this.initialize(cloudControllerUrl, restTemplate, oauthClient, loggregatorClient, cloudCredentials);
        this.sessionSpace = this.validateSpaceAndOrg(spaceName, orgName, tempClient);
    }

    private void initialize(URL cloudControllerUrl, RestTemplate restTemplate, OauthClient oauthClient, LoggregatorClient loggregatorClient, CloudCredentials cloudCredentials) {
        Assert.notNull(cloudControllerUrl, "CloudControllerUrl cannot be null");
        Assert.notNull(restTemplate, "RestTemplate cannot be null");
        Assert.notNull(oauthClient, "OauthClient cannot be null");
        oauthClient.init(cloudCredentials);
        this.cloudCredentials = cloudCredentials;
        this.cloudControllerUrl = cloudControllerUrl;
        this.restTemplate = restTemplate;
        this.configureCloudFoundryRequestFactory(restTemplate);
        this.oauthClient = oauthClient;
        this.loggregatorClient = loggregatorClient;
    }

    private CloudSpace validateSpaceAndOrg(String spaceName, String orgName, CloudControllerClientImpl client) {
        List<CloudSpace> spaces = client.getSpaces();
        for (CloudSpace space : spaces) {
            if (!space.getName().equals(spaceName)) continue;
            CloudOrganization org = space.getOrganization();
            if (orgName != null && !org.getName().equals(orgName)) continue;
            return space;
        }
        throw new IllegalArgumentException("No matching organization and space found for org: " + orgName + " space: " + spaceName);
    }

    @Override
    public void setResponseErrorHandler(ResponseErrorHandler errorHandler) {
        this.restTemplate.setErrorHandler(errorHandler);
    }

    @Override
    public URL getCloudControllerUrl() {
        return this.cloudControllerUrl;
    }

    @Override
    public void updatePassword(String newPassword) {
        this.updatePassword(this.cloudCredentials, newPassword);
    }

    @Override
    public Map<String, String> getLogs(String appName) {
        String urlPath = this.getFileUrlPath();
        String instance = String.valueOf(0);
        return this.doGetLogs(urlPath, appName, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApplicationLog> getRecentLogs(String appName) {
        AccumulatingApplicationLogListener listener = new AccumulatingApplicationLogListener();
        this.streamLoggregatorLogs(appName, listener, true);
        AccumulatingApplicationLogListener accumulatingApplicationLogListener = listener;
        synchronized (accumulatingApplicationLogListener) {
            try {
                listener.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return listener.getLogs();
    }

    @Override
    public StreamingLogToken streamLogs(String appName, ApplicationLogListener listener) {
        return this.streamLoggregatorLogs(appName, listener, false);
    }

    @Override
    public Map<String, String> getCrashLogs(String appName) {
        String urlPath = this.getFileUrlPath();
        CrashesInfo crashes = this.getCrashes(appName);
        if (crashes.getCrashes().isEmpty()) {
            return Collections.emptyMap();
        }
        TreeMap<Date, String> crashInstances = new TreeMap<Date, String>();
        for (CrashInfo crash : crashes.getCrashes()) {
            crashInstances.put(crash.getSince(), crash.getInstance());
        }
        String instance = (String)crashInstances.get(crashInstances.lastKey());
        return this.doGetLogs(urlPath, appName, instance);
    }

    @Override
    public String getFile(String appName, int instanceIndex, String filePath, int startPosition, int endPosition) {
        String urlPath = this.getFileUrlPath();
        Object appId = this.getFileAppId(appName);
        return this.doGetFile(urlPath, appId, instanceIndex, filePath, startPosition, endPosition);
    }

    @Override
    public void openFile(String appName, int instanceIndex, String filePath, ClientHttpResponseCallback callback) {
        String urlPath = this.getFileUrlPath();
        Object appId = this.getFileAppId(appName);
        this.doOpenFile(urlPath, appId, instanceIndex, filePath, callback);
    }

    @Override
    public void registerRestLogListener(RestLogCallback callBack) {
        if (this.getRestTemplate() instanceof LoggingRestTemplate) {
            ((LoggingRestTemplate)this.getRestTemplate()).registerRestLogListener(callBack);
        }
    }

    @Override
    public void unRegisterRestLogListener(RestLogCallback callBack) {
        if (this.getRestTemplate() instanceof LoggingRestTemplate) {
            ((LoggingRestTemplate)this.getRestTemplate()).unRegisterRestLogListener(callBack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStagingLogs(StartingInfo info, int offset) {
        String stagingFile = info.getStagingFile();
        if (stagingFile != null) {
            CloudFoundryClientHttpRequestFactory cfRequestFactory = null;
            try {
                HashMap<String, Integer> logsRequest = new HashMap<String, Integer>();
                logsRequest.put("offset", offset);
                CloudFoundryClientHttpRequestFactory cloudFoundryClientHttpRequestFactory = cfRequestFactory = this.getRestTemplate().getRequestFactory() instanceof CloudFoundryClientHttpRequestFactory ? (CloudFoundryClientHttpRequestFactory)this.getRestTemplate().getRequestFactory() : null;
                if (cfRequestFactory != null) {
                    cfRequestFactory.increaseReadTimeoutForStreamedTailedLogs(300000);
                }
                String string = this.getRestTemplate().getForObject(stagingFile + "&tail&tail_offset={offset}", String.class, logsRequest);
                return string;
            }
            catch (CloudFoundryException e) {
                if (e.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                    String string = null;
                    return string;
                }
                throw e;
            }
            catch (ResourceAccessException e) {
                this.logger.debug("Caught exception while fetching staging logs. Aborting. Caught:" + e, e);
            }
            finally {
                if (cfRequestFactory != null) {
                    cfRequestFactory.increaseReadTimeoutForStreamedTailedLogs(-1);
                }
            }
        }
        return null;
    }

    protected RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected String getUrl(String path) {
        return this.cloudControllerUrl + (path.startsWith("/") ? path : "/" + path);
    }

    protected void configureCloudFoundryRequestFactory(RestTemplate restTemplate) {
        ClientHttpRequestFactory requestFactory = restTemplate.getRequestFactory();
        if (!(requestFactory instanceof CloudFoundryClientHttpRequestFactory)) {
            restTemplate.setRequestFactory(new CloudFoundryClientHttpRequestFactory(requestFactory));
        }
    }

    protected Map<String, String> doGetLogs(String urlPath, String appName, String instance) {
        Object appId = this.getFileAppId(appName);
        String logFiles = this.doGetFile(urlPath, appId, instance, LOGS_LOCATION, -1, -1);
        String[] lines = logFiles.split("\n");
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String line : lines) {
            String[] parts = line.split("\\s");
            if (parts.length <= 0 || parts[0] == null) continue;
            fileNames.add(parts[0]);
        }
        HashMap<String, String> logs = new HashMap<String, String>(fileNames.size());
        for (String fileName : fileNames) {
            String logFile = "logs/" + fileName;
            logs.put(logFile, this.doGetFile(urlPath, appId, instance, logFile, -1, -1));
        }
        return logs;
    }

    protected void doOpenFile(String urlPath, Object app, int instanceIndex, String filePath, ClientHttpResponseCallback callback) {
        this.getRestTemplate().execute(this.getUrl(urlPath), HttpMethod.GET, null, new ResponseExtractorWrapper(callback), app, String.valueOf(instanceIndex), filePath);
    }

    protected String doGetFile(String urlPath, Object app, int instanceIndex, String filePath, int startPosition, int endPosition) {
        return this.doGetFile(urlPath, app, String.valueOf(instanceIndex), filePath, startPosition, endPosition);
    }

    protected String doGetFile(String urlPath, Object app, String instance, String filePath, int startPosition, int endPosition) {
        int end;
        int start;
        Assert.isTrue(startPosition >= -1, "Invalid start position value: " + startPosition);
        Assert.isTrue(endPosition >= -1, "Invalid end position value: " + endPosition);
        Assert.isTrue(startPosition < 0 || endPosition < 0 || endPosition >= startPosition, "The end position (" + endPosition + ") can't be less than the start position (" + startPosition + ")");
        if (startPosition == -1 && endPosition == -1) {
            start = 0;
            end = -1;
        } else {
            start = startPosition;
            end = endPosition;
        }
        String range = "bytes=" + (start == -1 ? "" : Integer.valueOf(start)) + "-" + (end == -1 ? "" : Integer.valueOf(end));
        return this.doGetFileByRange(urlPath, app, instance, filePath, start, end, range);
    }

    private String doGetFileByRange(String urlPath, Object app, String instance, String filePath, int start, int end, String range) {
        boolean supportsRanges;
        try {
            supportsRanges = this.getRestTemplate().execute(this.getUrl(urlPath), HttpMethod.HEAD, new RequestCallback(){

                public void doWithRequest(ClientHttpRequest request) throws IOException {
                    request.getHeaders().set("Range", "bytes=0-");
                }
            }, new ResponseExtractor<Boolean>(){

                @Override
                public Boolean extractData(ClientHttpResponse response) throws IOException {
                    return response.getStatusCode().equals((Object)HttpStatus.PARTIAL_CONTENT);
                }
            }, app, instance, filePath);
        }
        catch (CloudFoundryException e) {
            if (e.getStatusCode().equals((Object)HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE)) {
                return "";
            }
            throw e;
        }
        HttpHeaders headers = new HttpHeaders();
        if (supportsRanges) {
            headers.set("Range", range);
        }
        HttpEntity requestEntity = new HttpEntity(headers);
        ResponseEntity<String> responseEntity = this.getRestTemplate().exchange(this.getUrl(urlPath), HttpMethod.GET, requestEntity, String.class, app, instance, filePath);
        String response = (String)responseEntity.getBody();
        boolean partialFile = false;
        if (responseEntity.getStatusCode().equals((Object)HttpStatus.PARTIAL_CONTENT)) {
            partialFile = true;
        }
        if (!partialFile && response != null) {
            if (start == -1) {
                return response.substring(response.length() - end);
            }
            if (start >= response.length()) {
                if (response.length() == 0) {
                    return "";
                }
                throw new CloudFoundryException(HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE, "The starting position " + start + " is past the end of the file content.");
            }
            if (end != -1) {
                if (end >= response.length()) {
                    end = response.length() - 1;
                }
                return response.substring(start, end + 1);
            }
            return response.substring(start);
        }
        return response;
    }

    @Override
    public CloudInfo getInfo() {
        String infoV2Json = this.getRestTemplate().getForObject(this.getUrl("/v2/info"), String.class, new Object[0]);
        Map<String, Object> infoV2Map = JsonUtil.convertJsonToMap(infoV2Json);
        Map<String, Object> userMap = this.getUserInfo((String)infoV2Map.get("user"));
        String infoJson = this.getRestTemplate().getForObject(this.getUrl("/info"), String.class, new Object[0]);
        Map<String, Object> infoMap = JsonUtil.convertJsonToMap(infoJson);
        Map limitMap = (Map)infoMap.get("limits");
        Map usageMap = (Map)infoMap.get("usage");
        String name = CloudUtil.parse(String.class, infoV2Map.get("name"));
        String support = CloudUtil.parse(String.class, infoV2Map.get("support"));
        String authorizationEndpoint = CloudUtil.parse(String.class, infoV2Map.get("authorization_endpoint"));
        String build = CloudUtil.parse(String.class, infoV2Map.get("build"));
        String version = "" + CloudUtil.parse(Number.class, infoV2Map.get("version"));
        String description = CloudUtil.parse(String.class, infoV2Map.get("description"));
        CloudInfo.Limits limits = null;
        CloudInfo.Usage usage = null;
        boolean debug = false;
        if (this.oauthClient.getToken() != null) {
            limits = new CloudInfo.Limits(limitMap);
            usage = new CloudInfo.Usage(usageMap);
            debug = CloudUtil.parse(Boolean.class, infoMap.get("allow_debug"));
        }
        String loggregatorEndpoint = CloudUtil.parse(String.class, infoV2Map.get("logging_endpoint"));
        return new CloudInfo(name, support, authorizationEndpoint, build, version, (String)userMap.get("user_name"), description, limits, usage, debug, loggregatorEndpoint);
    }

    @Override
    public List<CloudSpace> getSpaces() {
        String urlPath = "/v2/spaces?inline-relations-depth=1";
        List<Map<String, Object>> resourceList = this.getAllResources(urlPath, null);
        ArrayList<CloudSpace> spaces = new ArrayList<CloudSpace>();
        for (Map<String, Object> resource : resourceList) {
            spaces.add(this.resourceMapper.mapResource(resource, CloudSpace.class));
        }
        return spaces;
    }

    @Override
    public List<CloudOrganization> getOrganizations() {
        String urlPath = "/v2/organizations?inline-relations-depth=0";
        List<Map<String, Object>> resourceList = this.getAllResources(urlPath, null);
        ArrayList<CloudOrganization> orgs = new ArrayList<CloudOrganization>();
        for (Map<String, Object> resource : resourceList) {
            orgs.add(this.resourceMapper.mapResource(resource, CloudOrganization.class));
        }
        return orgs;
    }

    @Override
    public OAuth2AccessToken login() {
        this.oauthClient.init(this.cloudCredentials);
        return this.oauthClient.getToken();
    }

    @Override
    public void logout() {
        this.oauthClient.clear();
    }

    @Override
    public void register(String email, String password) {
        throw new UnsupportedOperationException("Feature is not yet implemented.");
    }

    @Override
    public void updatePassword(CloudCredentials credentials, String newPassword) {
        this.oauthClient.changePassword(credentials.getPassword(), newPassword);
        CloudCredentials newCloudCredentials = new CloudCredentials(credentials.getEmail(), newPassword);
        this.cloudCredentials = this.cloudCredentials.getProxyUser() != null ? newCloudCredentials.proxyForUser(this.cloudCredentials.getProxyUser()) : newCloudCredentials;
    }

    @Override
    public void unregister() {
        throw new UnsupportedOperationException("Feature is not yet implemented.");
    }

    @Override
    public List<CloudService> getServices() {
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        String urlPath = "/v2";
        if (this.sessionSpace != null) {
            urlVars.put("space", this.sessionSpace.getMeta().getGuid());
            urlPath = urlPath + "/spaces/{space}";
        }
        urlPath = urlPath + "/service_instances?inline-relations-depth=1&return_user_provided_service_instances=true";
        List<Map<String, Object>> resourceList = this.getAllResources(urlPath, urlVars);
        ArrayList<CloudService> services = new ArrayList<CloudService>();
        for (Map<String, Object> resource : resourceList) {
            if (this.hasEmbeddedResource(resource, "service_plan")) {
                this.fillInEmbeddedResource(resource, "service_plan", "service");
            }
            services.add(this.resourceMapper.mapResource(resource, CloudService.class));
        }
        return services;
    }

    @Override
    public void createService(CloudService service) {
        this.assertSpaceProvided("create service");
        Assert.notNull(service, "Service must not be null");
        Assert.notNull(service.getName(), "Service name must not be null");
        Assert.notNull(service.getLabel(), "Service label must not be null");
        Assert.notNull(service.getPlan(), "Service plan must not be null");
        CloudServicePlan cloudServicePlan = this.findPlanForService(service);
        HashMap<String, Object> serviceRequest = new HashMap<String, Object>();
        serviceRequest.put("space_guid", this.sessionSpace.getMeta().getGuid());
        serviceRequest.put("name", service.getName());
        serviceRequest.put("service_plan_guid", cloudServicePlan.getMeta().getGuid());
        this.getRestTemplate().postForObject(this.getUrl("/v2/service_instances"), serviceRequest, String.class, new Object[0]);
    }

    private CloudServicePlan findPlanForService(CloudService service) {
        List<CloudServiceOffering> offerings = this.getServiceOfferings(service.getLabel());
        for (CloudServiceOffering offering : offerings) {
            if (service.getVersion() != null && !service.getVersion().equals(offering.getVersion())) continue;
            for (CloudServicePlan plan : offering.getCloudServicePlans()) {
                if (service.getPlan() == null || !service.getPlan().equals(plan.getName())) continue;
                return plan;
            }
        }
        throw new IllegalArgumentException("Service plan " + service.getPlan() + " not found");
    }

    @Override
    public void createUserProvidedService(CloudService service, Map<String, Object> credentials) {
        this.assertSpaceProvided("create service");
        Assert.notNull(credentials, "Service credentials must not be null");
        Assert.notNull(service, "Service must not be null");
        Assert.notNull(service.getName(), "Service name must not be null");
        Assert.isNull(service.getLabel(), "Service label is not valid for user-provided services");
        Assert.isNull(service.getProvider(), "Service provider is not valid for user-provided services");
        Assert.isNull(service.getVersion(), "Service version is not valid for user-provided services");
        Assert.isNull(service.getPlan(), "Service plan is not valid for user-provided services");
        HashMap<String, Object> serviceRequest = new HashMap<String, Object>();
        serviceRequest.put("space_guid", this.sessionSpace.getMeta().getGuid());
        serviceRequest.put("name", service.getName());
        serviceRequest.put("credentials", credentials);
        this.getRestTemplate().postForObject(this.getUrl("/v2/user_provided_service_instances"), serviceRequest, String.class, new Object[0]);
    }

    @Override
    public CloudService getService(String serviceName) {
        String urlPath = "/v2";
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        if (this.sessionSpace != null) {
            urlVars.put("space", this.sessionSpace.getMeta().getGuid());
            urlPath = urlPath + "/spaces/{space}";
        }
        urlVars.put("q", "name:" + serviceName);
        urlPath = urlPath + "/service_instances?q={q}&return_user_provided_service_instances=true";
        List<Map<String, Object>> resourceList = this.getAllResources(urlPath, urlVars);
        CloudService cloudService = null;
        if (resourceList.size() > 0) {
            Map<String, Object> resource = resourceList.get(0);
            if (this.hasEmbeddedResource(resource, "service_plan")) {
                this.fillInEmbeddedResource(resource, "service_plan", "service");
            }
            cloudService = this.resourceMapper.mapResource(resource, CloudService.class);
        }
        return cloudService;
    }

    @Override
    public void deleteService(String serviceName) {
        CloudService cloudService = this.getService(serviceName);
        this.doDeleteService(cloudService);
    }

    @Override
    public void deleteAllServices() {
        List<CloudService> cloudServices = this.getServices();
        for (CloudService cloudService : cloudServices) {
            this.doDeleteService(cloudService);
        }
    }

    @Override
    public List<CloudServiceOffering> getServiceOfferings() {
        String urlPath = "/v2/services?inline-relations-depth=1";
        List<Map<String, Object>> resourceList = this.getAllResources(urlPath, null);
        ArrayList<CloudServiceOffering> serviceOfferings = new ArrayList<CloudServiceOffering>();
        for (Map<String, Object> resource : resourceList) {
            CloudServiceOffering serviceOffering = this.resourceMapper.mapResource(resource, CloudServiceOffering.class);
            serviceOfferings.add(serviceOffering);
        }
        return serviceOfferings;
    }

    @Override
    public List<CloudServiceBroker> getServiceBrokers() {
        String urlPath = "/v2/service_brokers?inline-relations-depth=1";
        List<Map<String, Object>> resourceList = this.getAllResources(urlPath, null);
        ArrayList<CloudServiceBroker> serviceBrokers = new ArrayList<CloudServiceBroker>();
        for (Map<String, Object> resource : resourceList) {
            CloudServiceBroker broker = this.resourceMapper.mapResource(resource, CloudServiceBroker.class);
            serviceBrokers.add(broker);
        }
        return serviceBrokers;
    }

    @Override
    public List<CloudApplication> getApplications() {
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        String urlPath = "/v2";
        if (this.sessionSpace != null) {
            urlVars.put("space", this.sessionSpace.getMeta().getGuid());
            urlPath = urlPath + "/spaces/{space}";
        }
        urlPath = urlPath + "/apps?inline-relations-depth=1";
        List<Map<String, Object>> resourceList = this.getAllResources(urlPath, urlVars);
        ArrayList<CloudApplication> apps = new ArrayList<CloudApplication>();
        for (Map<String, Object> resource : resourceList) {
            this.processApplicationResource(resource, true);
            apps.add(this.mapCloudApplication(resource));
        }
        return apps;
    }

    @Override
    public CloudApplication getApplication(String appName) {
        Map<String, Object> resource = this.findApplicationResource(appName, true);
        if (resource == null) {
            throw new CloudFoundryException(HttpStatus.NOT_FOUND, "Not Found", "Application not found");
        }
        return this.mapCloudApplication(resource);
    }

    @Override
    public CloudApplication getApplication(UUID appGuid) {
        Map<String, Object> resource = this.findApplicationResource(appGuid, true);
        if (resource == null) {
            throw new CloudFoundryException(HttpStatus.NOT_FOUND, "Not Found", "Application not found");
        }
        return this.mapCloudApplication(resource);
    }

    private CloudApplication mapCloudApplication(Map<String, Object> resource) {
        UUID appId = this.resourceMapper.getGuidOfResource(resource);
        CloudApplication cloudApp = null;
        if (resource != null) {
            int running = this.getRunningInstances(appId, CloudApplication.AppState.valueOf(CloudEntityResourceMapper.getEntityAttribute(resource, "state", String.class)));
            ((Map)resource.get("entity")).put("running_instances", running);
            cloudApp = this.resourceMapper.mapResource(resource, CloudApplication.class);
            cloudApp.setUris(this.findApplicationUris(cloudApp.getMeta().getGuid()));
        }
        return cloudApp;
    }

    private int getRunningInstances(UUID appId, CloudApplication.AppState appState) {
        int running = 0;
        ApplicationStats appStats = this.doGetApplicationStats(appId, appState);
        if (appStats != null && appStats.getRecords() != null) {
            for (InstanceStats inst : appStats.getRecords()) {
                if (InstanceState.RUNNING != inst.getState()) continue;
                ++running;
            }
        }
        return running;
    }

    @Override
    public ApplicationStats getApplicationStats(String appName) {
        CloudApplication app = this.getApplication(appName);
        return this.doGetApplicationStats(app.getMeta().getGuid(), app.getState());
    }

    private ApplicationStats doGetApplicationStats(UUID appId, CloudApplication.AppState appState) {
        ArrayList<InstanceStats> instanceList = new ArrayList<InstanceStats>();
        if (appState.equals((Object)CloudApplication.AppState.STARTED)) {
            Map<String, Object> respMap = this.getInstanceInfoForApp(appId, "stats");
            for (String instanceId : respMap.keySet()) {
                InstanceStats instanceStats = new InstanceStats(instanceId, (Map)respMap.get(instanceId));
                instanceList.add(instanceStats);
            }
        }
        return new ApplicationStats(instanceList);
    }

    private Map<String, Object> getInstanceInfoForApp(UUID appId, String path) {
        String url = this.getUrl("/v2/apps/{guid}/" + path);
        HashMap<String, UUID> urlVars = new HashMap<String, UUID>();
        urlVars.put("guid", appId);
        String resp = this.getRestTemplate().getForObject(url, String.class, urlVars);
        return JsonUtil.convertJsonToMap(resp);
    }

    @Override
    public void createApplication(String appName, Staging staging, Integer memory, List<String> uris, List<String> serviceNames) {
        this.createApplication(appName, staging, null, memory, uris, serviceNames);
    }

    @Override
    public void createApplication(String appName, Staging staging, Integer disk, Integer memory, List<String> uris, List<String> serviceNames) {
        HashMap<String, Object> appRequest = new HashMap<String, Object>();
        appRequest.put("space_guid", this.sessionSpace.getMeta().getGuid());
        appRequest.put("name", appName);
        appRequest.put("memory", memory);
        if (disk != null) {
            appRequest.put("disk_quota", disk);
        }
        appRequest.put("instances", 1);
        this.addStagingToRequest(staging, appRequest);
        appRequest.put("state", (Object)CloudApplication.AppState.STOPPED);
        String appResp = this.getRestTemplate().postForObject(this.getUrl("/v2/apps"), appRequest, String.class, new Object[0]);
        Map<String, Object> appEntity = JsonUtil.convertJsonToMap(appResp);
        UUID newAppGuid = CloudEntityResourceMapper.getMeta(appEntity).getGuid();
        if (serviceNames != null && serviceNames.size() > 0) {
            this.updateApplicationServices(appName, serviceNames);
        }
        if (uris != null && uris.size() > 0) {
            this.addUris(uris, newAppGuid);
        }
    }

    private void addStagingToRequest(Staging staging, HashMap<String, Object> appRequest) {
        if (staging.getBuildpackUrl() != null) {
            appRequest.put("buildpack", staging.getBuildpackUrl());
        }
        if (staging.getCommand() != null) {
            appRequest.put("command", staging.getCommand());
        }
        if (staging.getStack() != null) {
            appRequest.put("stack_guid", this.getStack(staging.getStack()).getMeta().getGuid());
        }
        if (staging.getHealthCheckTimeout() != null) {
            appRequest.put("health_check_timeout", staging.getHealthCheckTimeout());
        }
    }

    private List<Map<String, Object>> getAllResources(String urlPath, Map<String, Object> urlVars) {
        ArrayList<Map<String, Object>> allResources = new ArrayList<Map<String, Object>>();
        String resp = urlVars != null ? this.getRestTemplate().getForObject(this.getUrl(urlPath), String.class, urlVars) : this.getRestTemplate().getForObject(this.getUrl(urlPath), String.class, new Object[0]);
        Map<String, Object> respMap = JsonUtil.convertJsonToMap(resp);
        List newResources = (List)respMap.get("resources");
        if (newResources != null && newResources.size() > 0) {
            allResources.addAll(newResources);
        }
        String nextUrl = (String)respMap.get("next_url");
        while (nextUrl != null && nextUrl.length() > 0) {
            nextUrl = this.addPageOfResources(nextUrl, allResources);
        }
        return allResources;
    }

    private String addPageOfResources(String nextUrl, List<Map<String, Object>> allResources) {
        String resp = this.getRestTemplate().getForObject(this.getUrl(nextUrl), String.class, new Object[0]);
        Map<String, Object> respMap = JsonUtil.convertJsonToMap(resp);
        List newResources = (List)respMap.get("resources");
        if (newResources != null && newResources.size() > 0) {
            allResources.addAll(newResources);
        }
        return (String)respMap.get("next_url");
    }

    private void addUris(List<String> uris, UUID appGuid) {
        Map<String, UUID> domains = this.getDomainGuids();
        for (String uri : uris) {
            HashMap<String, String> uriInfo = new HashMap<String, String>(2);
            this.extractUriInfo(domains, uri, uriInfo);
            UUID domainGuid = domains.get(uriInfo.get("domainName"));
            this.bindRoute((String)uriInfo.get("host"), domainGuid, appGuid);
        }
    }

    private void removeUris(List<String> uris, UUID appGuid) {
        Map<String, UUID> domains = this.getDomainGuids();
        for (String uri : uris) {
            HashMap<String, String> uriInfo = new HashMap<String, String>(2);
            this.extractUriInfo(domains, uri, uriInfo);
            UUID domainGuid = domains.get(uriInfo.get("domainName"));
            this.unbindRoute((String)uriInfo.get("host"), domainGuid, appGuid);
        }
    }

    protected void extractUriInfo(Map<String, UUID> domains, String uri, Map<String, String> uriInfo) {
        URI newUri = URI.create(uri);
        String authority = newUri.getScheme() != null ? newUri.getAuthority() : newUri.getPath();
        for (String domain : domains.keySet()) {
            String previousDomain;
            if (authority == null || !authority.endsWith(domain) || (previousDomain = uriInfo.get("domainName")) != null && domain.length() <= previousDomain.length()) continue;
            uriInfo.put("domainName", domain);
            if (domain.length() < authority.length()) {
                uriInfo.put("host", authority.substring(0, authority.indexOf(domain) - 1));
                continue;
            }
            if (domain.length() != authority.length()) continue;
            uriInfo.put("host", "");
        }
        if (uriInfo.get("domainName") == null) {
            throw new IllegalArgumentException("Domain not found for URI " + uri);
        }
        if (uriInfo.get("host") == null) {
            throw new IllegalArgumentException("Invalid URI " + uri + " -- host not specified for domain " + uriInfo.get("domainName"));
        }
    }

    private Map<String, UUID> getDomainGuids() {
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        String urlPath = "/v2";
        if (this.sessionSpace != null) {
            urlVars.put("space", this.sessionSpace.getMeta().getGuid());
            urlPath = urlPath + "/spaces/{space}";
        }
        String domainPath = urlPath + "/domains?inline-relations-depth=1";
        List<Map<String, Object>> resourceList = this.getAllResources(domainPath, urlVars);
        HashMap<String, UUID> domains = new HashMap<String, UUID>(resourceList.size());
        for (Map<String, Object> d : resourceList) {
            domains.put(CloudEntityResourceMapper.getEntityAttribute(d, "name", String.class), CloudEntityResourceMapper.getMeta(d).getGuid());
        }
        return domains;
    }

    private UUID getDomainGuid(String domainName, boolean required) {
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        String urlPath = "/v2/domains?inline-relations-depth=1&q=name:{name}";
        urlVars.put("name", domainName);
        List<Map<String, Object>> resourceList = this.getAllResources(urlPath, urlVars);
        UUID domainGuid = null;
        if (resourceList.size() > 0) {
            Map<String, Object> resource = resourceList.get(0);
            domainGuid = this.resourceMapper.getGuidOfResource(resource);
        }
        if (domainGuid == null && required) {
            throw new IllegalArgumentException("Domain '" + domainName + "' not found.");
        }
        return domainGuid;
    }

    private void bindRoute(String host, UUID domainGuid, UUID appGuid) {
        UUID routeGuid = this.getRouteGuid(host, domainGuid);
        if (routeGuid == null) {
            routeGuid = this.doAddRoute(host, domainGuid);
        }
        String bindPath = "/v2/apps/{app}/routes/{route}";
        HashMap<String, UUID> bindVars = new HashMap<String, UUID>();
        bindVars.put("app", appGuid);
        bindVars.put("route", routeGuid);
        HashMap bindRequest = new HashMap();
        this.getRestTemplate().put(this.getUrl(bindPath), bindRequest, bindVars);
    }

    private void unbindRoute(String host, UUID domainGuid, UUID appGuid) {
        UUID routeGuid = this.getRouteGuid(host, domainGuid);
        if (routeGuid != null) {
            String bindPath = "/v2/apps/{app}/routes/{route}";
            HashMap<String, UUID> bindVars = new HashMap<String, UUID>();
            bindVars.put("app", appGuid);
            bindVars.put("route", routeGuid);
            this.getRestTemplate().delete(this.getUrl(bindPath), bindVars);
        }
    }

    private UUID getRouteGuid(String host, UUID domainGuid) {
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        String urlPath = "/v2";
        urlPath = urlPath + "/routes?inline-relations-depth=0&q=host:{host}";
        urlVars.put("host", host);
        List<Map<String, Object>> allRoutes = this.getAllResources(urlPath, urlVars);
        UUID routeGuid = null;
        for (Map<String, Object> route : allRoutes) {
            UUID routeSpace = CloudEntityResourceMapper.getEntityAttribute(route, "space_guid", UUID.class);
            UUID routeDomain = CloudEntityResourceMapper.getEntityAttribute(route, "domain_guid", UUID.class);
            if (!this.sessionSpace.getMeta().getGuid().equals(routeSpace) || !domainGuid.equals(routeDomain)) continue;
            routeGuid = CloudEntityResourceMapper.getMeta(route).getGuid();
        }
        return routeGuid;
    }

    private UUID doAddRoute(String host, UUID domainGuid) {
        this.assertSpaceProvided("add route");
        HashMap<String, Object> routeRequest = new HashMap<String, Object>();
        routeRequest.put("host", host);
        routeRequest.put("domain_guid", domainGuid);
        routeRequest.put("space_guid", this.sessionSpace.getMeta().getGuid());
        String routeResp = this.getRestTemplate().postForObject(this.getUrl("/v2/routes"), routeRequest, String.class, new Object[0]);
        Map<String, Object> routeEntity = JsonUtil.convertJsonToMap(routeResp);
        return CloudEntityResourceMapper.getMeta(routeEntity).getGuid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadApplication(String appName, File file, UploadStatusCallback callback) throws IOException {
        Assert.notNull(file, "File must not be null");
        if (file.isDirectory()) {
            DirectoryApplicationArchive archive = new DirectoryApplicationArchive(file);
            this.uploadApplication(appName, archive, callback);
        } else {
            ZipFile zipFile = new ZipFile(file);
            try {
                ZipApplicationArchive archive = new ZipApplicationArchive(zipFile);
                this.uploadApplication(appName, archive, callback);
            }
            finally {
                zipFile.close();
            }
        }
    }

    @Override
    public void uploadApplication(String appName, ApplicationArchive archive, UploadStatusCallback callback) throws IOException {
        Assert.notNull(appName, "AppName must not be null");
        Assert.notNull(archive, "Archive must not be null");
        UUID appId = this.getAppId(appName);
        if (callback == null) {
            callback = UploadStatusCallback.NONE;
        }
        CloudResources knownRemoteResources = this.getKnownRemoteResources(archive);
        callback.onCheckResources();
        callback.onMatchedFileNames(knownRemoteResources.getFilenames());
        UploadApplicationPayload payload = new UploadApplicationPayload(archive, knownRemoteResources);
        callback.onProcessMatchedResources(payload.getTotalUncompressedSize());
        HttpEntity<MultiValueMap<String, ?>> entity = this.generatePartialResourceRequest(payload, knownRemoteResources);
        ResponseEntity<Map<String, Map<String, String>>> responseEntity = this.getRestTemplate().exchange(this.getUrl("/v2/apps/{guid}/bits?async=true"), HttpMethod.PUT, entity, new ParameterizedTypeReference<Map<String, Map<String, String>>>(){}, appId);
        this.processAsyncJob(responseEntity, callback);
    }

    private void processAsyncJob(ResponseEntity<Map<String, Map<String, String>>> jobCreationEntity, UploadStatusCallback callback) {
        String jobStatus;
        Map jobEntity = (Map)((Map)jobCreationEntity.getBody()).get("entity");
        do {
            boolean unsubscribe;
            if (unsubscribe = callback.onProgress(jobStatus = (String)jobEntity.get("status"))) {
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                return;
            }
            String jobId = (String)jobEntity.get("guid");
            ResponseEntity<Map<String, Map<String, String>>> jobProgressEntity = this.getRestTemplate().exchange(this.getUrl("/v2/jobs/{guid}"), HttpMethod.GET, HttpEntity.EMPTY, new ParameterizedTypeReference<Map<String, Map<String, String>>>(){}, jobId);
            jobEntity = (Map)((Map)jobProgressEntity.getBody()).get("entity");
        } while (!jobStatus.equals("finished"));
    }

    private CloudResources getKnownRemoteResources(ApplicationArchive archive) throws IOException {
        CloudResources archiveResources = new CloudResources(archive);
        String json = JsonUtil.convertToJson(archiveResources);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(JsonUtil.JSON_MEDIA_TYPE);
        HttpEntity<String> requestEntity = new HttpEntity<String>(json, headers);
        ResponseEntity<String> responseEntity = this.getRestTemplate().exchange(this.getUrl("/v2/resource_match"), HttpMethod.PUT, requestEntity, String.class, new Object[0]);
        List<CloudResource> cloudResources = JsonUtil.convertJsonToCloudResourceList((String)responseEntity.getBody());
        return new CloudResources(cloudResources);
    }

    private HttpEntity<MultiValueMap<String, ?>> generatePartialResourceRequest(UploadApplicationPayload application, CloudResources knownRemoteResources) throws IOException {
        LinkedMultiValueMap<String, Object> body = new LinkedMultiValueMap<String, Object>(2);
        body.add("application", application);
        ObjectMapper mapper = new ObjectMapper();
        String knownRemoteResourcesPayload = mapper.writeValueAsString(knownRemoteResources);
        body.add("resources", knownRemoteResourcesPayload);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        return new HttpEntity(body, headers);
    }

    @Override
    public StartingInfo startApplication(String appName) {
        CloudApplication app = this.getApplication(appName);
        if (app.getState() != CloudApplication.AppState.STARTED) {
            HashMap<String, CloudApplication.AppState> appRequest = new HashMap<String, CloudApplication.AppState>();
            appRequest.put("state", CloudApplication.AppState.STARTED);
            HttpEntity requestEntity = new HttpEntity(appRequest);
            ResponseEntity<String> entity = this.getRestTemplate().exchange(this.getUrl("/v2/apps/{guid}?stage_async=true"), HttpMethod.PUT, requestEntity, String.class, app.getMeta().getGuid());
            HttpHeaders headers = entity.getHeaders();
            if (headers != null && !headers.isEmpty()) {
                String stagingFile = headers.getFirst("x-app-staging-log");
                if (stagingFile != null) {
                    try {
                        stagingFile = URLDecoder.decode(stagingFile, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.error("unexpected inability to UTF-8 decode", e);
                    }
                }
                return new StartingInfo(stagingFile);
            }
        }
        return null;
    }

    @Override
    public void debugApplication(String appName, CloudApplication.DebugMode mode) {
        throw new UnsupportedOperationException("Feature is not yet implemented.");
    }

    @Override
    public void stopApplication(String appName) {
        CloudApplication app = this.getApplication(appName);
        if (app.getState() != CloudApplication.AppState.STOPPED) {
            HashMap<String, CloudApplication.AppState> appRequest = new HashMap<String, CloudApplication.AppState>();
            appRequest.put("state", CloudApplication.AppState.STOPPED);
            this.getRestTemplate().put(this.getUrl("/v2/apps/{guid}"), appRequest, app.getMeta().getGuid());
        }
    }

    @Override
    public StartingInfo restartApplication(String appName) {
        this.stopApplication(appName);
        return this.startApplication(appName);
    }

    @Override
    public void deleteApplication(String appName) {
        UUID appId = this.getAppId(appName);
        this.doDeleteApplication(appId);
    }

    @Override
    public void deleteAllApplications() {
        List<CloudApplication> cloudApps = this.getApplications();
        for (CloudApplication cloudApp : cloudApps) {
            this.deleteApplication(cloudApp.getName());
        }
    }

    @Override
    public void updateApplicationDiskQuota(String appName, int disk) {
        UUID appId = this.getAppId(appName);
        HashMap<String, Integer> appRequest = new HashMap<String, Integer>();
        appRequest.put("disk_quota", disk);
        this.getRestTemplate().put(this.getUrl("/v2/apps/{guid}"), appRequest, appId);
    }

    @Override
    public void updateApplicationMemory(String appName, int memory) {
        UUID appId = this.getAppId(appName);
        HashMap<String, Integer> appRequest = new HashMap<String, Integer>();
        appRequest.put("memory", memory);
        this.getRestTemplate().put(this.getUrl("/v2/apps/{guid}"), appRequest, appId);
    }

    @Override
    public void updateApplicationInstances(String appName, int instances) {
        UUID appId = this.getAppId(appName);
        HashMap<String, Integer> appRequest = new HashMap<String, Integer>();
        appRequest.put("instances", instances);
        this.getRestTemplate().put(this.getUrl("/v2/apps/{guid}"), appRequest, appId);
    }

    @Override
    public void updateApplicationServices(String appName, List<String> services) {
        CloudService cloudService;
        CloudApplication app = this.getApplication(appName);
        ArrayList<UUID> addServices = new ArrayList<UUID>();
        ArrayList<UUID> deleteServices = new ArrayList<UUID>();
        for (String serviceName : services) {
            if (app.getServices().contains(serviceName)) continue;
            cloudService = this.getService(serviceName);
            if (cloudService != null) {
                addServices.add(cloudService.getMeta().getGuid());
                continue;
            }
            throw new CloudFoundryException(HttpStatus.NOT_FOUND, "Service with name " + serviceName + " not found in current space " + this.sessionSpace.getName());
        }
        for (String serviceName : app.getServices()) {
            if (services.contains(serviceName) || (cloudService = this.getService(serviceName)) == null) continue;
            deleteServices.add(cloudService.getMeta().getGuid());
        }
        for (UUID serviceId : addServices) {
            this.doBindService(app.getMeta().getGuid(), serviceId);
        }
        for (UUID serviceId : deleteServices) {
            this.doUnbindService(app.getMeta().getGuid(), serviceId);
        }
    }

    private void doBindService(UUID appId, UUID serviceId) {
        HashMap<String, UUID> serviceRequest = new HashMap<String, UUID>();
        serviceRequest.put("service_instance_guid", serviceId);
        serviceRequest.put("app_guid", appId);
        this.getRestTemplate().postForObject(this.getUrl("/v2/service_bindings"), serviceRequest, String.class, new Object[0]);
    }

    private void doUnbindService(UUID appId, UUID serviceId) {
        UUID serviceBindingId = this.getServiceBindingId(appId, serviceId);
        this.getRestTemplate().delete(this.getUrl("/v2/service_bindings/{guid}"), serviceBindingId);
    }

    @Override
    public void updateApplicationStaging(String appName, Staging staging) {
        UUID appId = this.getAppId(appName);
        HashMap<String, Object> appRequest = new HashMap<String, Object>();
        this.addStagingToRequest(staging, appRequest);
        this.getRestTemplate().put(this.getUrl("/v2/apps/{guid}"), appRequest, appId);
    }

    @Override
    public void updateApplicationUris(String appName, List<String> uris) {
        CloudApplication app = this.getApplication(appName);
        ArrayList<String> newUris = new ArrayList<String>(uris);
        newUris.removeAll(app.getUris());
        List<String> removeUris = app.getUris();
        removeUris.removeAll(uris);
        this.removeUris(removeUris, app.getMeta().getGuid());
        this.addUris(newUris, app.getMeta().getGuid());
    }

    @Override
    public void updateApplicationEnv(String appName, Map<String, String> env) {
        UUID appId = this.getAppId(appName);
        HashMap<String, Map<String, String>> appRequest = new HashMap<String, Map<String, String>>();
        appRequest.put("environment_json", env);
        this.getRestTemplate().put(this.getUrl("/v2/apps/{guid}"), appRequest, appId);
    }

    @Override
    public void updateApplicationEnv(String appName, List<String> env) {
        HashMap<String, String> envHash = new HashMap<String, String>();
        for (String s : env) {
            if (!s.contains("=")) {
                throw new IllegalArgumentException("Environment setting without '=' is invalid: " + s);
            }
            String key = s.substring(0, s.indexOf(61)).trim();
            String value = s.substring(s.indexOf(61) + 1).trim();
            envHash.put(key, value);
        }
        this.updateApplicationEnv(appName, envHash);
    }

    @Override
    public void bindService(String appName, String serviceName) {
        CloudService cloudService = this.getService(serviceName);
        UUID appId = this.getAppId(appName);
        this.doBindService(appId, cloudService.getMeta().getGuid());
    }

    @Override
    public void unbindService(String appName, String serviceName) {
        CloudService cloudService = this.getService(serviceName);
        UUID appId = this.getAppId(appName);
        this.doUnbindService(appId, cloudService.getMeta().getGuid());
    }

    @Override
    public InstancesInfo getApplicationInstances(String appName) {
        CloudApplication app = this.getApplication(appName);
        return this.getApplicationInstances(app);
    }

    @Override
    public InstancesInfo getApplicationInstances(CloudApplication app) {
        if (app.getState().equals((Object)CloudApplication.AppState.STARTED)) {
            return this.doGetApplicationInstances(app.getMeta().getGuid());
        }
        return null;
    }

    private InstancesInfo doGetApplicationInstances(UUID appId) {
        try {
            ArrayList<Map<String, Object>> instanceList = new ArrayList<Map<String, Object>>();
            Map<String, Object> respMap = this.getInstanceInfoForApp(appId, "instances");
            ArrayList<String> keys = new ArrayList<String>(respMap.keySet());
            Collections.sort(keys);
            for (String instanceId : keys) {
                Integer index;
                try {
                    index = Integer.valueOf(instanceId);
                }
                catch (NumberFormatException e) {
                    index = -1;
                }
                Map instanceMap = (Map)respMap.get(instanceId);
                instanceMap.put("index", index);
                instanceList.add(instanceMap);
            }
            return new InstancesInfo(instanceList);
        }
        catch (CloudFoundryException e) {
            if (e.getStatusCode().equals((Object)HttpStatus.BAD_REQUEST)) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public CrashesInfo getCrashes(String appName) {
        UUID appId = this.getAppId(appName);
        if (appId == null) {
            throw new IllegalArgumentException("Application '" + appName + "' not found.");
        }
        HashMap<String, UUID> urlVars = new HashMap<String, UUID>();
        urlVars.put("guid", appId);
        String resp = this.getRestTemplate().getForObject(this.getUrl("/v2/apps/{guid}/crashes"), String.class, urlVars);
        Map<String, Object> respMap = JsonUtil.convertJsonToMap("{ \"crashes\" : " + resp + " }");
        List attributes = (List)respMap.get("crashes");
        return new CrashesInfo(attributes);
    }

    @Override
    public void rename(String appName, String newName) {
        UUID appId = this.getAppId(appName);
        HashMap<String, String> appRequest = new HashMap<String, String>();
        appRequest.put("name", newName);
        this.getRestTemplate().put(this.getUrl("/v2/apps/{guid}"), appRequest, appId);
    }

    @Override
    public List<CloudStack> getStacks() {
        String urlPath = "/v2/stacks";
        List<Map<String, Object>> resources = this.getAllResources(urlPath, null);
        ArrayList<CloudStack> stacks = new ArrayList<CloudStack>();
        for (Map<String, Object> resource : resources) {
            stacks.add(this.resourceMapper.mapResource(resource, CloudStack.class));
        }
        return stacks;
    }

    @Override
    public CloudStack getStack(String name) {
        String urlPath = "/v2/stacks?q={q}";
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        urlVars.put("q", "name:" + name);
        List<Map<String, Object>> resources = this.getAllResources(urlPath, urlVars);
        if (resources.size() > 0) {
            Map<String, Object> resource = resources.get(0);
            return this.resourceMapper.mapResource(resource, CloudStack.class);
        }
        return null;
    }

    @Override
    public List<CloudDomain> getDomainsForOrg() {
        this.assertSpaceProvided("access organization domains");
        return this.doGetDomains(this.sessionSpace.getOrganization());
    }

    @Override
    public List<CloudDomain> getDomains() {
        return this.doGetDomains((CloudOrganization)null);
    }

    @Override
    public List<CloudDomain> getPrivateDomains() {
        return this.doGetDomains("/v2/private_domains");
    }

    @Override
    public List<CloudDomain> getSharedDomains() {
        return this.doGetDomains("/v2/shared_domains");
    }

    @Override
    public CloudDomain getDefaultDomain() {
        List<CloudDomain> sharedDomains = this.getSharedDomains();
        if (sharedDomains.isEmpty()) {
            return null;
        }
        return sharedDomains.get(0);
    }

    @Override
    public void addDomain(String domainName) {
        this.assertSpaceProvided("add domain");
        UUID domainGuid = this.getDomainGuid(domainName, false);
        if (domainGuid == null) {
            this.doCreateDomain(domainName);
        }
    }

    @Override
    public void deleteDomain(String domainName) {
        this.assertSpaceProvided("delete domain");
        UUID domainGuid = this.getDomainGuid(domainName, true);
        List<CloudRoute> routes = this.getRoutes(domainName);
        if (routes.size() > 0) {
            throw new IllegalStateException("Unable to remove domain that is in use -- it has " + routes.size() + " routes.");
        }
        this.doDeleteDomain(domainGuid);
    }

    @Override
    public void removeDomain(String domainName) {
        this.deleteDomain(domainName);
    }

    @Override
    public List<CloudRoute> getRoutes(String domainName) {
        this.assertSpaceProvided("get routes for domain");
        UUID domainGuid = this.getDomainGuid(domainName, true);
        return this.doGetRoutes(domainGuid);
    }

    @Override
    public void addRoute(String host, String domainName) {
        this.assertSpaceProvided("add route for domain");
        UUID domainGuid = this.getDomainGuid(domainName, true);
        this.doAddRoute(host, domainGuid);
    }

    @Override
    public void deleteRoute(String host, String domainName) {
        this.assertSpaceProvided("delete route for domain");
        UUID domainGuid = this.getDomainGuid(domainName, true);
        UUID routeGuid = this.getRouteGuid(host, domainGuid);
        if (routeGuid == null) {
            throw new IllegalArgumentException("Host '" + host + "' not found for domain '" + domainName + "'.");
        }
        this.doDeleteRoute(routeGuid);
    }

    protected String getFileUrlPath() {
        return "/v2/apps/{appId}/instances/{instance}/files/{filePath}";
    }

    protected Object getFileAppId(String appName) {
        return this.getAppId(appName);
    }

    private void assertSpaceProvided(String operation) {
        Assert.notNull(this.sessionSpace, "Unable to " + operation + " without specifying organization and space to use.");
    }

    private void doDeleteRoute(UUID routeGuid) {
        HashMap<String, UUID> urlVars = new HashMap<String, UUID>();
        String urlPath = "/v2/routes/{route}";
        urlVars.put("route", routeGuid);
        this.getRestTemplate().delete(this.getUrl(urlPath), urlVars);
    }

    private List<CloudDomain> doGetDomains(CloudOrganization org) {
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        String urlPath = "/v2";
        if (org != null) {
            urlVars.put("org", org.getMeta().getGuid());
            urlPath = urlPath + "/organizations/{org}";
        }
        urlPath = urlPath + "/domains";
        return this.doGetDomains(urlPath, urlVars);
    }

    private List<CloudDomain> doGetDomains(String urlPath) {
        return this.doGetDomains(urlPath, null);
    }

    private List<CloudDomain> doGetDomains(String urlPath, Map<String, Object> urlVars) {
        List<Map<String, Object>> domainResources = this.getAllResources(urlPath, urlVars);
        ArrayList<CloudDomain> domains = new ArrayList<CloudDomain>();
        for (Map<String, Object> resource : domainResources) {
            domains.add(this.resourceMapper.mapResource(resource, CloudDomain.class));
        }
        return domains;
    }

    private UUID doCreateDomain(String domainName) {
        String urlPath = "/v2/private_domains";
        HashMap<String, Object> domainRequest = new HashMap<String, Object>();
        domainRequest.put("owning_organization_guid", this.sessionSpace.getOrganization().getMeta().getGuid());
        domainRequest.put("name", domainName);
        domainRequest.put("wildcard", true);
        String resp = this.getRestTemplate().postForObject(this.getUrl(urlPath), domainRequest, String.class, new Object[0]);
        Map<String, Object> respMap = JsonUtil.convertJsonToMap(resp);
        return this.resourceMapper.getGuidOfResource(respMap);
    }

    private void doDeleteDomain(UUID domainGuid) {
        HashMap<String, UUID> urlVars = new HashMap<String, UUID>();
        String urlPath = "/v2/private_domains/{domain}";
        urlVars.put("domain", domainGuid);
        this.getRestTemplate().delete(this.getUrl(urlPath), urlVars);
    }

    private List<CloudRoute> doGetRoutes(UUID domainGuid) {
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        String urlPath = "/v2";
        urlPath = urlPath + "/routes?inline-relations-depth=1";
        List<Map<String, Object>> allRoutes = this.getAllResources(urlPath, urlVars);
        ArrayList<CloudRoute> routes = new ArrayList<CloudRoute>();
        for (Map<String, Object> route : allRoutes) {
            UUID space = CloudEntityResourceMapper.getEntityAttribute(route, "space_guid", UUID.class);
            UUID domain = CloudEntityResourceMapper.getEntityAttribute(route, "domain_guid", UUID.class);
            if (!this.sessionSpace.getMeta().getGuid().equals(space) || !domainGuid.equals(domain)) continue;
            routes.add(this.resourceMapper.mapResource(route, CloudRoute.class));
        }
        return routes;
    }

    private void doDeleteService(CloudService cloudService) {
        List<UUID> appIds = this.getAppsBoundToService(cloudService);
        if (appIds.size() > 0) {
            for (UUID appId : appIds) {
                this.doUnbindService(appId, cloudService.getMeta().getGuid());
            }
        }
        this.getRestTemplate().delete(this.getUrl("/v2/service_instances/{guid}"), cloudService.getMeta().getGuid());
    }

    private List<UUID> getAppsBoundToService(CloudService cloudService) {
        ArrayList<UUID> appGuids = new ArrayList<UUID>();
        String urlPath = "/v2";
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        if (this.sessionSpace != null) {
            urlVars.put("space", this.sessionSpace.getMeta().getGuid());
            urlPath = urlPath + "/spaces/{space}";
        }
        urlVars.put("q", "name:" + cloudService.getName());
        urlPath = urlPath + "/service_instances?q={q}";
        List<Map<String, Object>> resourceList = this.getAllResources(urlPath, urlVars);
        for (Map<String, Object> resource : resourceList) {
            this.fillInEmbeddedResource(resource, "service_bindings");
            List bindings = CloudEntityResourceMapper.getEntityAttribute(resource, "service_bindings", List.class);
            for (Map binding : bindings) {
                String appId = CloudEntityResourceMapper.getEntityAttribute(binding, "app_guid", String.class);
                if (appId == null) continue;
                appGuids.add(UUID.fromString(appId));
            }
        }
        return appGuids;
    }

    private void doDeleteApplication(UUID appId) {
        this.getRestTemplate().delete(this.getUrl("/v2/apps/{guid}?recursive=true"), appId);
    }

    private List<CloudServiceOffering> getServiceOfferings(String label) {
        Assert.notNull(label, "Service label must not be null");
        List<Map<String, Object>> resourceList = this.getAllResources("/v2/services?inline-relations-depth=1", null);
        ArrayList<CloudServiceOffering> results = new ArrayList<CloudServiceOffering>();
        for (Map<String, Object> resource : resourceList) {
            CloudServiceOffering cloudServiceOffering = this.resourceMapper.mapResource(resource, CloudServiceOffering.class);
            if (cloudServiceOffering.getLabel() == null || !label.equals(cloudServiceOffering.getLabel())) continue;
            results.add(cloudServiceOffering);
        }
        return results;
    }

    private UUID getServiceBindingId(UUID appId, UUID serviceId) {
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        urlVars.put("guid", appId);
        List<Map<String, Object>> resourceList = this.getAllResources("/v2/apps/{guid}/service_bindings", urlVars);
        UUID serviceBindingId = null;
        if (resourceList != null && resourceList.size() > 0) {
            for (Map<String, Object> resource : resourceList) {
                Map bindingMeta = (Map)resource.get("metadata");
                Map bindingEntity = (Map)resource.get("entity");
                String serviceInstanceGuid = (String)bindingEntity.get("service_instance_guid");
                if (serviceInstanceGuid == null || !serviceInstanceGuid.equals(serviceId.toString())) continue;
                String bindingGuid = (String)bindingMeta.get("guid");
                serviceBindingId = UUID.fromString(bindingGuid);
                break;
            }
        }
        return serviceBindingId;
    }

    private UUID getAppId(String appName) {
        Map<String, Object> resource = this.findApplicationResource(appName, false);
        UUID guid = null;
        if (resource != null) {
            Map appMeta = (Map)resource.get("metadata");
            guid = UUID.fromString(String.valueOf(appMeta.get("guid")));
        }
        return guid;
    }

    private StreamingLogToken streamLoggregatorLogs(String appName, ApplicationLogListener listener, boolean recent) {
        ClientEndpointConfig.Configurator configurator = new ClientEndpointConfig.Configurator(){

            @Override
            public void beforeRequest(Map<String, List<String>> headers) {
                String authorizationHeader = CloudControllerClientImpl.this.oauthClient.getAuthorizationHeader();
                if (authorizationHeader != null) {
                    headers.put(CloudControllerClientImpl.AUTHORIZATION_HEADER_KEY, Arrays.asList(authorizationHeader));
                }
            }
        };
        String endpoint = this.getInfo().getLoggregatorEndpoint();
        String mode = recent ? "dump" : "tail";
        UUID appId = this.getAppId(appName);
        return this.loggregatorClient.connectToLoggregator(endpoint, mode, appId, listener, configurator);
    }

    private Map<String, Object> findApplicationResource(UUID appGuid, boolean fetchServiceInfo) {
        HashMap<String, UUID> urlVars = new HashMap<String, UUID>();
        String urlPath = "/v2/apps/{app}?inline-relations-depth=1";
        urlVars.put("app", appGuid);
        String resp = this.getRestTemplate().getForObject(this.getUrl(urlPath), String.class, urlVars);
        return this.processApplicationResource(JsonUtil.convertJsonToMap(resp), fetchServiceInfo);
    }

    private Map<String, Object> findApplicationResource(String appName, boolean fetchServiceInfo) {
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        String urlPath = "/v2";
        if (this.sessionSpace != null) {
            urlVars.put("space", this.sessionSpace.getMeta().getGuid());
            urlPath = urlPath + "/spaces/{space}";
        }
        urlVars.put("q", "name:" + appName);
        urlPath = urlPath + "/apps?inline-relations-depth=1&q={q}";
        List<Map<String, Object>> allResources = this.getAllResources(urlPath, urlVars);
        if (!allResources.isEmpty()) {
            return this.processApplicationResource(allResources.get(0), fetchServiceInfo);
        }
        return null;
    }

    private Map<String, Object> processApplicationResource(Map<String, Object> resource, boolean fetchServiceInfo) {
        if (fetchServiceInfo) {
            this.fillInEmbeddedResource(resource, "service_bindings", "service_instance");
        }
        this.fillInEmbeddedResource(resource, "stack");
        return resource;
    }

    private List<String> findApplicationUris(UUID appGuid) {
        String urlPath = "/v2/apps/{app}/routes?inline-relations-depth=1";
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        urlVars.put("app", appGuid);
        List<Map<String, Object>> resourceList = this.getAllResources(urlPath, urlVars);
        ArrayList<String> uris = new ArrayList<String>();
        for (Map<String, Object> resource : resourceList) {
            Map<String, Object> domainResource = CloudEntityResourceMapper.getEmbeddedResource(resource, "domain");
            String host = CloudEntityResourceMapper.getEntityAttribute(resource, "host", String.class);
            String domain = CloudEntityResourceMapper.getEntityAttribute(domainResource, "name", String.class);
            if (host != null && host.length() > 0) {
                uris.add(host + "." + domain);
                continue;
            }
            uris.add(domain);
        }
        return uris;
    }

    private Map<String, Object> getUserInfo(String user) {
        String userJson = "{}";
        OAuth2AccessToken accessToken = this.oauthClient.getToken();
        if (accessToken != null) {
            String tokenString = accessToken.getValue();
            int x = tokenString.indexOf(46);
            int y = tokenString.indexOf(46, x + 1);
            String encodedString = tokenString.substring(x + 1, y);
            try {
                byte[] decodedBytes = new BASE64Decoder().decodeBuffer(encodedString);
                userJson = new String(decodedBytes, 0, decodedBytes.length, "UTF-8");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return JsonUtil.convertJsonToMap(userJson);
    }

    private void fillInEmbeddedResource(Map<String, Object> resource, String ... resourcePath) {
        Object embeddedResource;
        if (resourcePath.length == 0) {
            return;
        }
        Map entity = (Map)resource.get("entity");
        String headKey = resourcePath[0];
        String[] tailPath = Arrays.copyOfRange(resourcePath, 1, resourcePath.length);
        if (!entity.containsKey(headKey)) {
            Map responseMap;
            String pathUrl = entity.get(headKey + "_url").toString();
            Object response = this.getRestTemplate().getForObject(this.getUrl(pathUrl), Object.class, new Object[0]);
            if (response instanceof Map && (responseMap = (Map)response).containsKey("resources")) {
                response = responseMap.get("resources");
            }
            entity.put(headKey, response);
        }
        if ((embeddedResource = entity.get(headKey)) instanceof Map) {
            Map embeddedResourceMap = (Map)embeddedResource;
            this.fillInEmbeddedResource(embeddedResourceMap, tailPath);
        } else if (embeddedResource instanceof List) {
            List embeddedResourcesList = (List)embeddedResource;
            for (Object r : embeddedResourcesList) {
                this.fillInEmbeddedResource((Map)r, tailPath);
            }
        } else {
            return;
        }
    }

    private boolean hasEmbeddedResource(Map<String, Object> resource, String resourceKey) {
        Map entity = (Map)resource.get("entity");
        return entity.containsKey(resourceKey) || entity.containsKey(resourceKey + "_url");
    }

    private static class ResponseExtractorWrapper
    implements ResponseExtractor {
        private ClientHttpResponseCallback callback;

        public ResponseExtractorWrapper(ClientHttpResponseCallback callback) {
            this.callback = callback;
        }

        public Object extractData(ClientHttpResponse clientHttpResponse) throws IOException {
            this.callback.onClientHttpResponse(clientHttpResponse);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AccumulatingApplicationLogListener
    implements ApplicationLogListener {
        private List<ApplicationLog> logs = new ArrayList<ApplicationLog>();

        private AccumulatingApplicationLogListener() {
        }

        @Override
        public void onMessage(ApplicationLog log) {
            this.logs.add(log);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable exception) {
            AccumulatingApplicationLogListener accumulatingApplicationLogListener = this;
            synchronized (accumulatingApplicationLogListener) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            AccumulatingApplicationLogListener accumulatingApplicationLogListener = this;
            synchronized (accumulatingApplicationLogListener) {
                this.notify();
            }
        }

        public List<ApplicationLog> getLogs() {
            Collections.sort(this.logs);
            return this.logs;
        }
    }

    public static class CloudFoundryFormHttpMessageConverter
    extends FormHttpMessageConverter {
        protected String getFilename(Object part) {
            if (part instanceof UploadApplicationPayload) {
                return ((UploadApplicationPayload)part).getArchive().getFilename();
            }
            return super.getFilename(part);
        }
    }

    private class CloudFoundryClientHttpRequestFactory
    implements ClientHttpRequestFactory {
        private ClientHttpRequestFactory delegate;
        private Integer defaultSocketTimeout = 0;

        public CloudFoundryClientHttpRequestFactory(ClientHttpRequestFactory delegate) {
            this.delegate = delegate;
            this.captureDefaultReadTimeout();
        }

        public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
            ClientHttpRequest request = this.delegate.createRequest(uri, httpMethod);
            String authorizationHeader = CloudControllerClientImpl.this.oauthClient.getAuthorizationHeader();
            if (authorizationHeader != null) {
                request.getHeaders().add(CloudControllerClientImpl.AUTHORIZATION_HEADER_KEY, authorizationHeader);
            }
            if (CloudControllerClientImpl.this.cloudCredentials != null && CloudControllerClientImpl.this.cloudCredentials.getProxyUser() != null) {
                request.getHeaders().add(CloudControllerClientImpl.PROXY_USER_HEADER_KEY, CloudControllerClientImpl.this.cloudCredentials.getProxyUser());
            }
            return request;
        }

        private void captureDefaultReadTimeout() {
            if (this.delegate instanceof HttpComponentsClientHttpRequestFactory) {
                HttpComponentsClientHttpRequestFactory httpRequestFactory = (HttpComponentsClientHttpRequestFactory)this.delegate;
                this.defaultSocketTimeout = (Integer)httpRequestFactory.getHttpClient().getParams().getParameter("http.socket.timeout");
                if (this.defaultSocketTimeout == null) {
                    try {
                        this.defaultSocketTimeout = new Socket().getSoTimeout();
                    }
                    catch (SocketException e) {
                        this.defaultSocketTimeout = 0;
                    }
                }
            }
        }

        public void increaseReadTimeoutForStreamedTailedLogs(int timeout) {
            if (this.delegate instanceof HttpComponentsClientHttpRequestFactory) {
                HttpComponentsClientHttpRequestFactory httpRequestFactory = (HttpComponentsClientHttpRequestFactory)this.delegate;
                if (timeout > 0) {
                    httpRequestFactory.setReadTimeout(timeout);
                } else {
                    httpRequestFactory.setReadTimeout(this.defaultSocketTimeout);
                }
            }
        }
    }
}

