/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.rest;

import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.cloudfoundry.client.lib.ApplicationLogListener;
import org.cloudfoundry.client.lib.CloudOperationException;
import org.cloudfoundry.client.lib.rest.LoggregatorMessageHandler;

public class LoggregatorEndpoint
extends Endpoint {
    private ApplicationLogListener listener;

    public LoggregatorEndpoint(ApplicationLogListener listener) {
        this.listener = listener;
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.addMessageHandler(new LoggregatorMessageHandler(this.listener));
    }

    public void onClose(Session session, CloseReason closeReason) {
        if (closeReason.getCloseCode() == CloseReason.CloseCodes.NORMAL_CLOSURE || closeReason.getCloseCode() == CloseReason.CloseCodes.GOING_AWAY) {
            this.listener.onComplete();
        } else {
            this.listener.onError(new CloudOperationException("Loggregrator connection closed unexpectedly " + closeReason));
        }
    }

    public void onError(Session session, Throwable throwable) {
        this.listener.onError(throwable);
    }
}

