/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.rest;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Date;
import javax.websocket.MessageHandler;
import loggregator.LogMessages;
import org.cloudfoundry.client.lib.ApplicationLogListener;
import org.cloudfoundry.client.lib.domain.ApplicationLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggregatorMessageHandler
implements MessageHandler.Whole<byte[]> {
    private static final long NANOSECONDS_IN_MILLISECOND = 1000000L;
    private ApplicationLogListener listener;

    public LoggregatorMessageHandler(ApplicationLogListener listener) {
        this.listener = listener;
    }

    @Override
    public void onMessage(byte[] rawMessage) {
        try {
            LogMessages.Message message = LogMessages.Message.parseFrom(rawMessage);
            ApplicationLog.MessageType messageType = message.getMessageType() == LogMessages.Message.MessageType.OUT ? ApplicationLog.MessageType.STDOUT : ApplicationLog.MessageType.STDERR;
            this.listener.onMessage(new ApplicationLog(message.getAppId(), message.getMessage().toStringUtf8(), new Date(message.getTimestamp() / 1000000L), messageType, message.getSourceName(), message.getSourceId()));
        }
        catch (InvalidProtocolBufferException e) {
            this.listener.onError(e);
        }
    }
}

