/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.util;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.lib.domain.UploadApplicationPayload;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadApplicationPayloadHttpMessageConverter
implements HttpMessageConverter<UploadApplicationPayload> {
    @Override
    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    @Override
    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return UploadApplicationPayload.class.isAssignableFrom(clazz);
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return Collections.singletonList(MediaType.ALL);
    }

    @Override
    public UploadApplicationPayload read(Class<? extends UploadApplicationPayload> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(UploadApplicationPayload t, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        HttpHeaders headers = outputMessage.getHeaders();
        if (contentType == null || contentType.isWildcardType() || contentType.isWildcardSubtype()) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        if (contentType != null) {
            headers.setContentType(contentType);
        }
        FileCopyUtils.copy(t.getInputStream(), outputMessage.getBody());
        outputMessage.getBody().flush();
    }
}

