/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client;

import io.socket.SocketIOException;
import org.eclipse.flux.client.util.ExceptionUtil;

public class ConnectionStatus {
    private final Kind kind;
    private final Throwable error;
    public static final ConnectionStatus INITIALIZING = new ConnectionStatus(Kind.INITIALIZING, null);

    private ConnectionStatus(Kind kind, Throwable error) {
        this.kind = kind;
        this.error = error;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("ConnectionStatus(");
        s.append((Object)this.kind);
        if (this.error != null) {
            s.append(" = ");
            s.append(ExceptionUtil.getMessage(this.error));
            s.append(")");
        }
        return s.toString();
    }

    public ConnectionStatus connect() {
        return new ConnectionStatus(Kind.CONNECTED, null);
    }

    public ConnectionStatus error(Throwable error) {
        return new ConnectionStatus(Kind.CLOSED, error);
    }

    public ConnectionStatus reconnect() {
        return new ConnectionStatus(Kind.INITIALIZING, this.error);
    }

    public ConnectionStatus close() {
        return new ConnectionStatus(Kind.CLOSED, this.error);
    }

    public boolean isAuthFailure() {
        if (this.error instanceof SocketIOException) {
            SocketIOException e = (SocketIOException)this.error;
            String msg = e.getMessage();
            return msg != null && msg.contains("handshaking");
        }
        return false;
    }

    public boolean isConnected() {
        return this.kind == Kind.CONNECTED;
    }

    static enum Kind {
        INITIALIZING,
        CONNECTED,
        CLOSED;

    }
}

