/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client;

import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.MessageHandler;
import org.eclipse.flux.client.util.Assert;
import org.eclipse.flux.client.util.Console;
import org.eclipse.flux.client.util.ExceptionUtil;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class RequestResponseHandler
extends MessageHandler {
    private MessageConnector flux;
    private String responseType;
    private static final Console console = Console.get(RequestResponseHandler.class.getName());

    public RequestResponseHandler(MessageConnector flux, String type) {
        super(type);
        this.flux = flux;
        this.responseType = type.replaceAll("Request$", "Response");
        Assert.assertTrue(this.responseType.endsWith("Response"));
    }

    @Override
    public final void handle(String type, JSONObject req) {
        try {
            JSONObject res;
            try {
                res = this.createResponse(type, req);
            }
            catch (Throwable e) {
                console.log(e);
                this.flux.send(this.responseType, this.errorResponse(req, e));
                return;
            }
            this.flux.send(this.responseType, res);
        }
        catch (Exception e) {
            console.log(e);
        }
    }

    protected JSONObject createResponse(String type, JSONObject req) throws Exception {
        JSONObject res = this.copy(req);
        return this.fillResponse(type, req, res);
    }

    protected JSONObject copy(JSONObject req) {
        try {
            JSONObject res = new JSONObject(req);
            for (String name : JSONObject.getNames(req)) {
                res.put(name, req.get(name));
            }
            return res;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected JSONObject fillResponse(String type, JSONObject req, JSONObject res) throws Exception {
        return res;
    }

    protected JSONObject errorResponse(JSONObject req, Throwable e) {
        try {
            JSONObject res = this.copy(req);
            res.put("error", ExceptionUtil.getMessage(e));
            res.put("errorDetails", ExceptionUtil.stackTrace(e));
            return res;
        }
        catch (JSONException shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }
}

