/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client.config;

import com.rabbitmq.client.ConnectionFactory;
import org.eclipse.flux.client.FluxClient;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.config.AbstractFluxConfig;
import org.eclipse.flux.client.config.FluxConfig;
import org.eclipse.flux.client.config.SocketIOFluxConfig;
import org.eclipse.flux.client.impl.RabbitMQMessageConnector;
import org.eclipse.flux.client.util.Console;
import org.eclipse.flux.client.util.JSON;
import org.json.JSONArray;
import org.json.JSONObject;

public class RabbitMQFluxConfig
extends AbstractFluxConfig {
    private static Console console = Console.get(RabbitMQFluxConfig.class.getName());
    private String uri = null;
    private SocketIOFluxConfig socketIOConfig = null;

    public RabbitMQFluxConfig(String fluxUser) {
        super(fluxUser);
    }

    @Override
    public MessageConnector connect(FluxClient fluxClient) throws Exception {
        return new RabbitMQMessageConnector(fluxClient, this);
    }

    @Override
    public SocketIOFluxConfig toSocketIO() {
        return this.socketIOConfig;
    }

    public RabbitMQFluxConfig setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public RabbitMQFluxConfig setSocketIOConf(SocketIOFluxConfig socketIOConfig) {
        this.socketIOConfig = socketIOConfig;
        return this;
    }

    public void applyTo(ConnectionFactory f) throws Exception {
        if (this.uri != null) {
            f.setUri(this.uri);
        } else {
            f.setHost("localhost");
        }
    }

    public static String rabbitUrl() throws Exception {
        String vcapServices = System.getenv("VCAP_SERVICES");
        if (vcapServices != null) {
            JSONObject svcInfo = JSON.parse(vcapServices);
            console.log("VCAP_SERVICES = " + svcInfo);
            for (String label : JSONObject.getNames(svcInfo)) {
                JSONArray svcs = svcInfo.getJSONArray(label);
                for (int index = 0; index < svcs.length(); ++index) {
                    String uri = svcs.getJSONObject(index).getJSONObject("credentials").getString("uri");
                    if (!uri.contains("amqp")) continue;
                    console.log("rabbit url = " + uri);
                    return uri;
                }
            }
            throw new Error("Running on CF requires that you bind a amqp service to this app");
        }
        return "amqp://localhost";
    }

    public static FluxConfig superConfig() throws Exception {
        return new RabbitMQFluxConfig("$super$").setUri(RabbitMQFluxConfig.rabbitUrl());
    }

    public String getURI() {
        return this.uri;
    }
}

