/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client.config;

import org.eclipse.flux.client.FluxClient;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.config.AbstractFluxConfig;
import org.eclipse.flux.client.config.FluxConfig;
import org.eclipse.flux.client.impl.SocketIOMessageConnector;

public class SocketIOFluxConfig
extends AbstractFluxConfig {
    private final String host;
    private final String token;
    public static final String DEFAULT_FLUX_USER = "defaultuser";
    private static final String DEFAULT_FLUX_HOST = "http://localhost:3000";

    public String getHost() {
        return this.host;
    }

    public String getToken() {
        return this.token;
    }

    public SocketIOFluxConfig(String host, String login, String token) {
        super(login);
        this.host = host;
        this.token = token;
    }

    @Override
    public String toString() {
        return "SocketIOFluxConfig(" + this.getUser() + "@" + this.host + ")";
    }

    public static FluxConfig defaultConfig() {
        return new SocketIOFluxConfig(SocketIOFluxConfig.envHost(), SocketIOFluxConfig.envLogin(), SocketIOFluxConfig.envToken());
    }

    public static FluxConfig superConfig() {
        return new SocketIOFluxConfig(SocketIOFluxConfig.envHost(), "$super$", SocketIOFluxConfig.envToken());
    }

    private static String envToken() {
        String token = System.getProperty("flux-token");
        if (token == null) {
            token = System.getenv("FLUX_TOKEN");
        }
        return token;
    }

    private static String envLogin() {
        String login = System.getProperty("flux-user");
        if (login == null) {
            login = System.getenv("FLUX_USER");
        }
        if (login == null) {
            login = DEFAULT_FLUX_USER;
        }
        return login;
    }

    private static String envHost() {
        String fluxhost = System.getProperty("flux-host");
        if (fluxhost == null) {
            fluxhost = System.getenv("FLUX_HOST");
        }
        if (fluxhost == null) {
            fluxhost = DEFAULT_FLUX_HOST;
        }
        return fluxhost;
    }

    @Override
    public MessageConnector connect(FluxClient client) {
        return new SocketIOMessageConnector(this, client.getExecutor());
    }

    @Override
    public SocketIOFluxConfig toSocketIO() {
        return this;
    }
}

