/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client.impl;

import org.eclipse.flux.client.impl.RabbitMQMessageConnector;
import org.json.JSONObject;

public abstract class DeliveryType {
    private String name;
    public static final DeliveryType REQUEST = new DeliveryType("REQUEST"){

        @Override
        public void send(RabbitMQMessageConnector connector, String messageType, JSONObject data) throws Exception {
            String outbox = connector.outbox;
            data.put("requestSenderID", connector.inbox);
            connector.channel.basicPublish(outbox, connector.usernameToRoutingKey(data.getString("username")), null, connector.encode(messageType, data));
        }
    };
    public static final DeliveryType BROADCAST = new DeliveryType("BROADCAST"){

        @Override
        public void send(RabbitMQMessageConnector connector, String type, JSONObject data) throws Exception {
            String outbox = connector.outbox;
            data.put("senderID", connector.inbox);
            connector.channel.basicPublish(outbox, connector.usernameToRoutingKey(data.getString("username")), null, connector.encode(type, data));
        }
    };
    public static final DeliveryType RESPONSE = new DeliveryType("RESPONSE"){

        @Override
        public void send(RabbitMQMessageConnector connector, String type, JSONObject data) throws Exception {
            data.put("responseSenderID", connector.inbox);
            connector.channel.basicPublish("", data.getString("requestSenderID"), null, connector.encode(type, data));
        }
    };

    public DeliveryType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public abstract void send(RabbitMQMessageConnector var1, String var2, JSONObject var3) throws Exception;
}

