/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.flux.client.impl.DeliveryType;
import org.eclipse.flux.client.util.Assert;

public class DeliveryTypes {
    public static final DeliveryTypes DEFAULTS = new DeliveryTypes();
    private Map<String, DeliveryType> map = new HashMap<String, DeliveryType>();

    public synchronized DeliveryType get(String messageType) {
        DeliveryType dt = this.map.get(messageType);
        if (dt == null && (dt = this.computeDefault(messageType)) != null) {
            this.map.put(messageType, dt);
        }
        Assert.assertTrue(dt != null);
        return dt;
    }

    protected DeliveryType computeDefault(String messageType) {
        if (messageType.endsWith("Request")) {
            return DeliveryType.REQUEST;
        }
        if (messageType.endsWith("Response")) {
            return DeliveryType.RESPONSE;
        }
        return DeliveryType.BROADCAST;
    }

    public synchronized DeliveryTypes put(String messageType, DeliveryType deliveryType) {
        this.map.put(messageType, deliveryType);
        return this;
    }
}

