/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.service.common;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.UploadStatusCallback;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.Staging;
import org.eclipse.flux.service.common.IServiceLauncher;
import org.springframework.http.HttpStatus;

public class CloudFoundryServiceLauncher
implements IServiceLauncher {
    private CloudFoundryClient cfClient;
    private String appId;
    private final int maxInstancesNumber;

    public CloudFoundryServiceLauncher(String appId, URL cfControllerUrl, String orgName, String spaceName, String cfLogin, String cfPassword, String fluxUrl, String username, String password, File appLocation, int maxInstancesNumber) throws IOException {
        this.appId = appId;
        if (maxInstancesNumber < 1) {
            throw new IllegalArgumentException("Max number of instances cannot be less than 1.");
        }
        this.maxInstancesNumber = maxInstancesNumber;
        this.cfClient = new CloudFoundryClient(new CloudCredentials(cfLogin, cfPassword), cfControllerUrl, orgName, spaceName);
        this.cfClient.login();
        try {
            CloudApplication cfApp = this.cfClient.getApplication(appId);
            if (cfApp != null) {
                this.cfClient.deleteApplication(appId);
            }
        }
        catch (CloudFoundryException e) {
            System.out.println(e.getMessage());
        }
        this.cfClient.createApplication(appId, new Staging(), 1024, null, null);
        this.cfClient.uploadApplication(appId, appLocation, new UploadStatusCallback(){

            @Override
            public boolean onProgress(String arg0) {
                System.out.println("Progress: " + arg0);
                return false;
            }

            @Override
            public void onProcessMatchedResources(int arg0) {
                System.out.println("Matching Resources: " + arg0);
            }

            @Override
            public void onMatchedFileNames(Set<String> arg0) {
                System.out.println("Matching file names: " + arg0);
            }

            @Override
            public void onCheckResources() {
                System.out.println("Check resources!");
            }
        });
        this.cfClient.updateApplicationEnv(appId, this.createEnv(fluxUrl, username, password));
    }

    @Override
    public synchronized void init() {
        this.cfClient.login();
        this.cfClient.startApplication(this.appId);
    }

    @Override
    public synchronized void startService(int n) throws Exception {
        this.cfClient.login();
        boolean updated = false;
        while (!updated) {
            try {
                int numberOfInstances = this.cfClient.getApplication(this.appId).getInstances();
                int difference = this.maxInstancesNumber - n - numberOfInstances;
                if (difference < 0) {
                    n += difference;
                }
                if (n > 0) {
                    this.cfClient.updateApplicationInstances(this.appId, numberOfInstances + n);
                }
                updated = true;
                if (difference > 0) continue;
                throw new Exception("Maximum number of services is running. Cannot start anymore services!");
            }
            catch (CloudFoundryException cfe) {
                if (cfe.getStatusCode() == HttpStatus.NOT_FOUND) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                throw cfe;
            }
        }
    }

    @Override
    public void dispose() {
        this.cfClient.login();
        this.cfClient.stopApplication(this.appId);
    }

    private List<String> createEnv(String fluxUrl, String username, String password) {
        ArrayList<String> env = new ArrayList<String>(3);
        env.add("FLUX_HOST=" + fluxUrl);
        env.add("FLUX_USER_ID=" + username.replace("$", "\\$"));
        env.add("FLUX_USER_TOKEN=" + password);
        env.add("FLUX_LAZY_START=true");
        env.add("FLUX_INIT_JDT=true");
        return env;
    }
}

