/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.service.common;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.flux.client.IChannelListener;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.service.common.IServiceLauncher;
import org.json.JSONException;
import org.json.JSONObject;

public class ToolingServiceProvider {
    private static final long EXPECTED_RESPONSE_TIMEOUT = 500L;
    private static final long POOL_MAINTENANCE_PERIOD = 120000L;
    private static final long POOL_MAINTENANCE_NOW_DELAY = 50L;
    private static final long POOL_INITIALIZATION_WAIT_TIME_STEP = 1000L;
    private static final long POOL_INITIALIZATION_TIMEOUT = 120000L;
    private static final String DISCOVER_SERVICE_REQUEST = "discoverServiceRequest";
    private static final String DISCOVER_SERVICE_RESPONSE = "discoverServiceResponse";
    private static final String SERVICE_STATUS_CHANGE = "serviceStatusChange";
    private static final String SERVICE_REQUIRED_REQUEST = "serviceRequiredRequest";
    private static final String SERVICE_REQUIRED_RESPONSE = "serviceRequiredResponse";
    private static final String[] JSON_PROPERTIES = new String[]{"username", "service", "requestSenderID"};
    private AtomicBoolean active = new AtomicBoolean(false);
    private MessageConnector messageConnector;
    private ScheduledExecutorService poolMaintenanceExecutor;
    private ExecutorService serviceLauncherExecutor;
    private String serviceId;
    private IServiceLauncher serviceLauncher = null;
    private int poolSize;
    private IMessageHandler[] messageHandlers;
    private ScheduledFuture<?> poolMaintenanceFuture;
    private Exception launchException;
    private final boolean autoMaintainServicePoolSize;
    private Runnable poolMaintenanceOperation = new PoolMaintenanceOperation();
    private final IChannelListener CONNECTION_LISTENER = new IChannelListener(){

        @Override
        public void connected(String userChannel) {
            if ("$super$".equals(userChannel)) {
                ToolingServiceProvider.this.init();
            }
        }

        @Override
        public void disconnected(String userChannel) {
            if ("$super$".equals(userChannel)) {
                ToolingServiceProvider.this.dispose();
            }
        }
    };

    public ToolingServiceProvider(final MessageConnector messageConnector, final String serviceId, IServiceLauncher serviceLauncher, int poolSize, boolean autoMaintainServicePoolSize) {
        this.messageConnector = messageConnector;
        this.serviceId = serviceId;
        this.poolSize = poolSize;
        this.autoMaintainServicePoolSize = autoMaintainServicePoolSize;
        this.serviceLauncher(serviceLauncher);
        this.messageHandlers = new IMessageHandler[]{new IMessageHandler(){

            @Override
            public boolean canHandle(String type, JSONObject message) {
                try {
                    return message.getString("username").equals("$super$") && message.getString("service").equals(serviceId);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return false;
                }
            }

            @Override
            public void handle(String type, JSONObject message) {
                try {
                    messageConnector.send(ToolingServiceProvider.SERVICE_REQUIRED_RESPONSE, new JSONObject(message, JSON_PROPERTIES));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public String getMessageType() {
                return ToolingServiceProvider.SERVICE_REQUIRED_REQUEST;
            }
        }, new IMessageHandler(){

            @Override
            public boolean canHandle(String type, JSONObject message) {
                try {
                    return message.getString("service").equals(serviceId);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return false;
                }
            }

            @Override
            public void handle(String type, JSONObject message) {
                try {
                    JSONObject statusMessage = new JSONObject(message, JSON_PROPERTIES);
                    statusMessage.put("status", "unavailable");
                    String error = ToolingServiceProvider.this.getError();
                    if (error == null) {
                        statusMessage.put("info", "Starting up services, please wait...");
                    } else {
                        statusMessage.put("error", ToolingServiceProvider.this.getError());
                    }
                    messageConnector.send(ToolingServiceProvider.DISCOVER_SERVICE_RESPONSE, statusMessage);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public String getMessageType() {
                return ToolingServiceProvider.DISCOVER_SERVICE_REQUEST;
            }
        }, new IMessageHandler(){

            @Override
            public boolean canHandle(String type, JSONObject message) {
                try {
                    return message.getString("service").equals(serviceId) && "ready".equals(message.getString("status")) && !"$super$".equals(message.get("username"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return false;
                }
            }

            @Override
            public void handle(String type, JSONObject message) {
                ToolingServiceProvider.this.schedulePoolMaintenance();
            }

            @Override
            public String getMessageType() {
                return ToolingServiceProvider.SERVICE_STATUS_CHANGE;
            }
        }};
    }

    private synchronized String getError() {
        if (this.launchException != null) {
            return this.launchException.getMessage();
        }
        return null;
    }

    private void init() {
        new Thread(){

            @Override
            public void run() {
                if (ToolingServiceProvider.this.serviceLauncher != null) {
                    ToolingServiceProvider.this.serviceLauncher.init();
                }
                ToolingServiceProvider.this.serviceLauncherExecutor = Executors.newFixedThreadPool(5);
                ToolingServiceProvider.this.poolMaintenanceExecutor = Executors.newScheduledThreadPool(1);
                new PoolInitilizationOperation().run();
                for (IMessageHandler messageHandler : ToolingServiceProvider.this.messageHandlers) {
                    ToolingServiceProvider.this.messageConnector.addMessageHandler(messageHandler);
                }
            }
        }.start();
    }

    private void validateState() {
        if (this.active.get()) {
            throw new IllegalArgumentException("Cannot set parameters when service manager is running!");
        }
    }

    public ToolingServiceProvider serviceLauncher(IServiceLauncher serviceLauncher) {
        this.validateState();
        if (serviceLauncher == null) {
            throw new IllegalArgumentException("Parameter must not be NULL!");
        }
        this.serviceLauncher = serviceLauncher;
        return this;
    }

    public final void stop() {
        if (!this.active.get()) {
            return;
        }
        this.dispose();
        this.messageConnector.removeChannelListener(this.CONNECTION_LISTENER);
        this.active.set(false);
    }

    private void dispose() {
        for (IMessageHandler messageHandler : this.messageHandlers) {
            this.messageConnector.removeMessageHandler(messageHandler);
        }
        if (this.poolMaintenanceFuture != null) {
            this.poolMaintenanceFuture.cancel(false);
        }
        this.poolMaintenanceExecutor.shutdown();
        this.serviceLauncherExecutor.shutdown();
        if (this.serviceLauncher != null) {
            this.serviceLauncher.dispose();
        }
    }

    public final void start() {
        if (this.active.get()) {
            return;
        }
        this.active.set(true);
        this.messageConnector.addChannelListener(this.CONNECTION_LISTENER);
        if (this.messageConnector.isConnected("$super$")) {
            this.CONNECTION_LISTENER.connected("$super$");
        } else {
            this.messageConnector.connectToChannel("$super$");
        }
    }

    private void startService(final int n) {
        this.serviceLauncherExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ToolingServiceProvider.this.serviceLauncher.startService(n);
                    ToolingServiceProvider.this.setLaunchException(null);
                }
                catch (Exception e) {
                    ToolingServiceProvider.this.setLaunchException(e);
                }
            }
        });
    }

    private synchronized void setLaunchException(Exception e) {
        this.launchException = e;
    }

    private void schedulePoolMaintenance() {
        if (this.poolMaintenanceFuture != null) {
            this.poolMaintenanceFuture.cancel(false);
        }
        this.poolMaintenanceFuture = this.autoMaintainServicePoolSize ? this.poolMaintenanceExecutor.scheduleWithFixedDelay(this.poolMaintenanceOperation, 50L, 120000L, TimeUnit.MILLISECONDS) : this.poolMaintenanceExecutor.schedule(this.poolMaintenanceOperation, 50L, TimeUnit.MILLISECONDS);
    }

    private class PoolInitilizationOperation
    extends PoolMaintenanceOperation {
        private PoolInitilizationOperation() {
        }

        @Override
        public synchronized void run() {
            int numberOfServicesToStart = ToolingServiceProvider.this.poolSize - this.getNumberOfServicesRunning();
            if (numberOfServicesToStart > 0) {
                System.out.println("Need to start " + numberOfServicesToStart + " services");
                final AtomicInteger counter = new AtomicInteger(numberOfServicesToStart);
                IMessageHandler readyServiceHanlder = new IMessageHandler(){

                    @Override
                    public boolean canHandle(String type, JSONObject message) {
                        try {
                            return message.getString("service").equals(ToolingServiceProvider.this.serviceId) && "ready".equals(message.getString("status")) && "$super$".equals(message.get("username"));
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }

                    @Override
                    public void handle(String type, JSONObject message) {
                        if (counter.decrementAndGet() <= 0) {
                            ToolingServiceProvider.this.messageConnector.removeMessageHandler(this);
                        }
                    }

                    @Override
                    public String getMessageType() {
                        return ToolingServiceProvider.SERVICE_STATUS_CHANGE;
                    }
                };
                ToolingServiceProvider.this.messageConnector.addMessageHandler(readyServiceHanlder);
                ToolingServiceProvider.this.startService(numberOfServicesToStart);
                System.out.println("Populating service pool.");
                for (long time = 0L; counter.get() > 0 && time < 120000L; time += 1000L) {
                    try {
                        Thread.sleep(1000L);
                        System.out.print(".");
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ToolingServiceProvider.this.messageConnector.removeMessageHandler(readyServiceHanlder);
                System.out.println();
                int n = counter.get();
                if (n > 0) {
                    System.out.println("WARNING: Service pool hasn't been completely initialized. " + n + " service(s) are missing.");
                } else {
                    System.out.println("Service pool has been successfully populated");
                }
            } else {
                System.out.println("Service pool is already filled up");
            }
        }
    }

    private class PoolMaintenanceOperation
    implements Runnable {
        private PoolMaintenanceOperation() {
        }

        protected synchronized int getNumberOfServicesRunning() {
            final AtomicInteger counter = new AtomicInteger(0);
            IMessageHandler messageHandler = new IMessageHandler(){

                @Override
                public void handle(String type, JSONObject message) {
                    counter.incrementAndGet();
                }

                @Override
                public String getMessageType() {
                    return ToolingServiceProvider.DISCOVER_SERVICE_RESPONSE;
                }

                @Override
                public boolean canHandle(String type, JSONObject message) {
                    try {
                        return message.getString("service").equals(ToolingServiceProvider.this.serviceId) && "ready".equals(message.getString("status"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            ToolingServiceProvider.this.messageConnector.addMessageHandler(messageHandler);
            try {
                JSONObject discoverMessage = new JSONObject();
                discoverMessage.put("service", ToolingServiceProvider.this.serviceId);
                discoverMessage.put("username", "$super$");
                ToolingServiceProvider.this.messageConnector.send(ToolingServiceProvider.DISCOVER_SERVICE_REQUEST, discoverMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ToolingServiceProvider.this.messageConnector.removeMessageHandler(messageHandler);
            return counter.get();
        }

        @Override
        public synchronized void run() {
            int numberOfServicesToStart = ToolingServiceProvider.this.poolSize - this.getNumberOfServicesRunning();
            if (numberOfServicesToStart > 0) {
                ToolingServiceProvider.this.startService(numberOfServicesToStart);
            }
        }
    }
}

