/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.resource;

import java.util.List;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseOAuth2ProtectedResourceDetails
implements OAuth2ProtectedResourceDetails {
    private String id;
    private String grantType = "unsupported";
    private String clientId;
    private String accessTokenUri;
    private List<String> scope;
    private String clientSecret;
    private AuthenticationScheme clientAuthenticationScheme = AuthenticationScheme.header;
    private AuthenticationScheme authorizationScheme = AuthenticationScheme.header;
    private String tokenName = "access_token";

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getAccessTokenUri() {
        return this.accessTokenUri;
    }

    public void setAccessTokenUri(String accessTokenUri) {
        this.accessTokenUri = accessTokenUri;
    }

    @Override
    public boolean isScoped() {
        return this.scope != null && !this.scope.isEmpty();
    }

    @Override
    public List<String> getScope() {
        return this.scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    @Override
    public boolean isAuthenticationRequired() {
        return StringUtils.hasText(this.clientId) && this.clientAuthenticationScheme != AuthenticationScheme.none;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Override
    public AuthenticationScheme getClientAuthenticationScheme() {
        return this.clientAuthenticationScheme;
    }

    public void setClientAuthenticationScheme(AuthenticationScheme clientAuthenticationScheme) {
        this.clientAuthenticationScheme = clientAuthenticationScheme;
    }

    @Override
    public boolean isClientOnly() {
        return false;
    }

    @Override
    public AuthenticationScheme getAuthenticationScheme() {
        return this.authorizationScheme;
    }

    public void setAuthenticationScheme(AuthenticationScheme authorizationScheme) {
        this.authorizationScheme = authorizationScheme;
    }

    @Override
    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    @Override
    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseOAuth2ProtectedResourceDetails)) {
            return false;
        }
        BaseOAuth2ProtectedResourceDetails that = (BaseOAuth2ProtectedResourceDetails)o;
        return !(this.id == null ? that.id != null : !this.id.equals(that.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

