/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.token;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAccessTokenRequest
implements AccessTokenRequest {
    private final MultiValueMap<String, String> parameters = new LinkedMultiValueMap<String, String>();
    private Object state;
    private OAuth2AccessToken existingToken;
    private String currentUri;
    private String cookie;

    public DefaultAccessTokenRequest() {
    }

    public DefaultAccessTokenRequest(Map<String, String[]> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                this.parameters.put(entry.getKey(), (String)((Object)Arrays.asList((Object[])entry.getValue())));
            }
        }
    }

    @Override
    public boolean isError() {
        return this.parameters.containsKey("error");
    }

    @Override
    public Object getPreservedState() {
        return this.state;
    }

    @Override
    public void setPreservedState(Object state) {
        this.state = state;
    }

    @Override
    public String getStateKey() {
        return this.getFirst("state");
    }

    @Override
    public void setStateKey(String state) {
        this.parameters.set("state", state);
    }

    @Override
    public String getCurrentUri() {
        return this.currentUri;
    }

    @Override
    public void setCurrentUri(String uri) {
        this.currentUri = uri;
    }

    @Override
    public String getAuthorizationCode() {
        return this.getFirst("code");
    }

    @Override
    public void setAuthorizationCode(String code) {
        this.parameters.set("code", code);
    }

    @Override
    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    @Override
    public String getCookie() {
        return this.cookie;
    }

    @Override
    public void setExistingToken(OAuth2AccessToken existingToken) {
        this.existingToken = existingToken;
    }

    @Override
    public OAuth2AccessToken getExistingToken() {
        return this.existingToken;
    }

    @Override
    public String getFirst(String key) {
        return this.parameters.getFirst(key);
    }

    @Override
    public void add(String key, String value) {
        this.parameters.add(key, value);
    }

    @Override
    public void set(String key, String value) {
        this.parameters.set(key, value);
    }

    @Override
    public void setAll(Map<String, String> values) {
        this.parameters.setAll(values);
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        return this.parameters.toSingleValueMap();
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.parameters.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.parameters.containsValue(value);
    }

    @Override
    public List<String> get(Object key) {
        return (List)this.parameters.get(key);
    }

    @Override
    public List<String> put(String key, List<String> value) {
        return this.parameters.put(key, (String)((Object)value));
    }

    @Override
    public List<String> remove(Object key) {
        return (List)this.parameters.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> m) {
        this.parameters.putAll(m);
    }

    @Override
    public void clear() {
        this.parameters.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.parameters.keySet();
    }

    @Override
    public Collection<List<String>> values() {
        return this.parameters.values();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.parameters.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.parameters.equals(o);
    }

    @Override
    public int hashCode() {
        return this.parameters.hashCode();
    }

    public String toString() {
        return this.parameters.toString();
    }
}

