/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config;

import java.util.List;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.provider.BaseClientDetails;
import org.springframework.security.oauth2.provider.InMemoryClientDetailsService;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientDetailsServiceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    @Override
    protected Class<?> getBeanClass(Element element) {
        return InMemoryClientDetailsService.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List<Element> clientElements = DomUtils.getChildElementsByTagName(element, "client");
        ManagedMap<String, AbstractBeanDefinition> clients = new ManagedMap<String, AbstractBeanDefinition>();
        for (Element clientElement : clientElements) {
            String refreshValidity;
            BeanDefinitionBuilder client = BeanDefinitionBuilder.rootBeanDefinition(BaseClientDetails.class);
            String clientId = clientElement.getAttribute("client-id");
            if (StringUtils.hasText(clientId)) {
                client.addConstructorArgValue(clientId);
            } else {
                parserContext.getReaderContext().error("A client id must be supplied with the definition of a client.", clientElement);
            }
            String secret = clientElement.getAttribute("secret");
            if (StringUtils.hasText(secret)) {
                client.addPropertyValue("clientSecret", secret);
            }
            String resourceIds = clientElement.getAttribute("resource-ids");
            if (StringUtils.hasText(clientId)) {
                client.addConstructorArgValue(resourceIds);
            } else {
                client.addConstructorArgValue("");
            }
            String redirectUri = clientElement.getAttribute("redirect-uri");
            String tokenValidity = clientElement.getAttribute("access-token-validity");
            if (StringUtils.hasText(tokenValidity)) {
                client.addPropertyValue("accessTokenValiditySeconds", tokenValidity);
            }
            if (StringUtils.hasText(refreshValidity = clientElement.getAttribute("refresh-token-validity"))) {
                client.addPropertyValue("refreshTokenValiditySeconds", refreshValidity);
            }
            client.addConstructorArgValue(clientElement.getAttribute("scope"));
            client.addConstructorArgValue(clientElement.getAttribute("authorized-grant-types"));
            client.addConstructorArgValue(clientElement.getAttribute("authorities"));
            if (StringUtils.hasText(redirectUri)) {
                client.addConstructorArgValue(redirectUri);
            }
            clients.put(clientId, client.getBeanDefinition());
        }
        builder.addPropertyValue("clientDetailsStore", clients);
    }
}

