/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.client.resource.BaseOAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitResourceDetails;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    @Override
    protected Class<?> getBeanClass(Element element) {
        if ("authorization_code".equals(element.getAttribute("type"))) {
            return AuthorizationCodeResourceDetails.class;
        }
        if ("implicit".equals(element.getAttribute("type"))) {
            return ImplicitResourceDetails.class;
        }
        if ("client_credentials".equals(element.getAttribute("type"))) {
            return ClientCredentialsResourceDetails.class;
        }
        return BaseOAuth2ProtectedResourceDetails.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String scope;
        String useCurrentUri;
        String requireImmediateAuthorization;
        String userAuthorizationUri;
        String clientAuthenticationScheme;
        String id = element.getAttribute("id");
        if (!StringUtils.hasText(id)) {
            parserContext.getReaderContext().error("An id must be supplied on a resource element.", element);
        }
        builder.addPropertyValue("id", id);
        String type = element.getAttribute("type");
        if (!StringUtils.hasText(type)) {
            type = "client_credentials";
        }
        builder.addPropertyValue("grantType", type);
        String accessTokenUri = element.getAttribute("access-token-uri");
        if (!StringUtils.hasText(accessTokenUri) && !"implicit".equals(type)) {
            parserContext.getReaderContext().error("An accessTokenUri must be supplied on a resource element of type " + type, element);
        }
        builder.addPropertyValue("accessTokenUri", accessTokenUri);
        String clientId = element.getAttribute("client-id");
        if (!StringUtils.hasText(clientId)) {
            parserContext.getReaderContext().error("An clientId must be supplied on a resource element", element);
        }
        builder.addPropertyValue("clientId", clientId);
        String clientSecret = element.getAttribute("client-secret");
        if (StringUtils.hasText(clientSecret)) {
            builder.addPropertyValue("clientSecret", clientSecret);
        }
        if (StringUtils.hasText(clientAuthenticationScheme = element.getAttribute("client-authentication-scheme"))) {
            builder.addPropertyValue("clientAuthenticationScheme", clientAuthenticationScheme);
        }
        if (StringUtils.hasText(userAuthorizationUri = element.getAttribute("user-authorization-uri"))) {
            if (type.equals("client_credentials")) {
                parserContext.getReaderContext().error("The client_credentials grant type does not accept an authorization URI", element);
            } else {
                builder.addPropertyValue("userAuthorizationUri", userAuthorizationUri);
            }
        } else if (!type.equals("client_credentials")) {
            parserContext.getReaderContext().error("An authorization URI must be supplied for a resource of type " + type, element);
        }
        String preEstablishedRedirectUri = element.getAttribute("pre-established-redirect-uri");
        if (StringUtils.hasText(preEstablishedRedirectUri)) {
            builder.addPropertyValue("preEstablishedRedirectUri", preEstablishedRedirectUri);
        }
        if (StringUtils.hasText(requireImmediateAuthorization = element.getAttribute("require-immediate-authorization"))) {
            builder.addPropertyValue("requireImmediateAuthorization", requireImmediateAuthorization);
        }
        if (StringUtils.hasText(useCurrentUri = element.getAttribute("use-current-uri"))) {
            builder.addPropertyValue("useCurrentUri", useCurrentUri);
        }
        if (StringUtils.hasText(scope = element.getAttribute("scope"))) {
            BeanDefinitionBuilder scopesBuilder = BeanDefinitionBuilder.genericBeanDefinition(StringListFactoryBean.class);
            scopesBuilder.addConstructorArgValue(new TypedStringValue(scope));
            builder.addPropertyValue("scope", scopesBuilder.getBeanDefinition());
        }
        AuthenticationScheme btm = AuthenticationScheme.header;
        String bearerTokenMethod = element.getAttribute("authentication-scheme");
        if (StringUtils.hasText(bearerTokenMethod)) {
            btm = AuthenticationScheme.valueOf(bearerTokenMethod);
        }
        builder.addPropertyValue("authenticationScheme", (Object)btm);
        String bearerTokenName = element.getAttribute("token-name");
        if (!StringUtils.hasText(bearerTokenName)) {
            bearerTokenName = "access_token";
        }
        builder.addPropertyValue("tokenName", bearerTokenName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringListFactoryBean
    implements FactoryBean<List<String>> {
        private final String commaSeparatedList;

        public StringListFactoryBean(String commaSeparatedList) {
            this.commaSeparatedList = commaSeparatedList;
        }

        @Override
        public List<String> getObject() throws Exception {
            return new ArrayList<String>(Arrays.asList(StringUtils.commaDelimitedListToStringArray(this.commaSeparatedList)));
        }

        @Override
        public Class<?> getObjectType() {
            return List.class;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }
    }
}

