/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.config.ProviderBeanDefinitionParser;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationManager;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationProcessingFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ResourceServerBeanDefinitionParser
extends ProviderBeanDefinitionParser {
    protected AbstractBeanDefinition parseEndpointAndReturnFilter(Element element, ParserContext parserContext, String tokenServicesRef, String serializerRef) {
        String resourceId = element.getAttribute("resource-id");
        String entryPointRef = element.getAttribute("entry-point-ref");
        BeanDefinitionBuilder protectedResourceFilterBean = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthenticationProcessingFilter.class);
        BeanDefinitionBuilder authenticationManagerBean = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthenticationManager.class);
        authenticationManagerBean.addPropertyReference("tokenServices", tokenServicesRef);
        if (StringUtils.hasText(resourceId)) {
            authenticationManagerBean.addPropertyValue("resourceId", resourceId);
        }
        protectedResourceFilterBean.addPropertyValue("authenticationManager", authenticationManagerBean.getBeanDefinition());
        if (StringUtils.hasText(entryPointRef)) {
            protectedResourceFilterBean.addPropertyReference("authenticationEntryPoint", entryPointRef);
        }
        return protectedResourceFilterBean.getBeanDefinition();
    }
}

