/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.http.converter;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormOAuth2ExceptionHttpMessageConverter
implements HttpMessageConverter<OAuth2Exception> {
    private static final List<MediaType> SUPPORTED_MEDIA = Collections.singletonList(MediaType.APPLICATION_FORM_URLENCODED);
    private final FormHttpMessageConverter delegateMessageConverter = new FormHttpMessageConverter();

    @Override
    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return OAuth2Exception.class.equals(clazz) && MediaType.APPLICATION_FORM_URLENCODED.equals(mediaType);
    }

    @Override
    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return OAuth2Exception.class.equals(clazz) && MediaType.APPLICATION_FORM_URLENCODED.equals(mediaType);
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return SUPPORTED_MEDIA;
    }

    @Override
    public OAuth2Exception read(Class<? extends OAuth2Exception> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Object data = this.delegateMessageConverter.read((Class)null, inputMessage);
        Map<String, String> flattenedData = data.toSingleValueMap();
        return OAuth2Exception.valueOf(flattenedData);
    }

    @Override
    public void write(OAuth2Exception t, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        LinkedMultiValueMap<String, String> data = new LinkedMultiValueMap<String, String>();
        data.add("error", t.getOAuth2ErrorCode());
        data.add("error_description", t.getMessage());
        Map<String, String> additionalInformation = t.getAdditionalInformation();
        if (additionalInformation != null) {
            for (Map.Entry<String, String> entry : additionalInformation.entrySet()) {
                data.add(entry.getKey(), entry.getValue());
            }
        }
        this.delegateMessageConverter.write((MultiValueMap<String, ?>)data, contentType, outputMessage);
    }
}

