/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.oauth2.provider.AuthorizationRequestManager;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequestManager;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.error.DefaultWebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.util.Assert;

public class AbstractEndpoint
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private WebResponseExceptionTranslator providerExceptionHandler = new DefaultWebResponseExceptionTranslator();
    private TokenGranter tokenGranter;
    private ClientDetailsService clientDetailsService;
    private AuthorizationRequestManager authorizationRequestManager;
    private AuthorizationRequestManager defaultAuthorizationRequestManager;

    public void afterPropertiesSet() throws Exception {
        Assert.state(this.tokenGranter != null, "TokenGranter must be provided");
        Assert.state(this.clientDetailsService != null, "ClientDetailsService must be provided");
        this.defaultAuthorizationRequestManager = new DefaultAuthorizationRequestManager(this.getClientDetailsService());
        if (this.authorizationRequestManager == null) {
            this.authorizationRequestManager = this.defaultAuthorizationRequestManager;
        }
    }

    public void setProviderExceptionHandler(WebResponseExceptionTranslator providerExceptionHandler) {
        this.providerExceptionHandler = providerExceptionHandler;
    }

    public void setTokenGranter(TokenGranter tokenGranter) {
        this.tokenGranter = tokenGranter;
    }

    protected TokenGranter getTokenGranter() {
        return this.tokenGranter;
    }

    protected WebResponseExceptionTranslator getExceptionTranslator() {
        return this.providerExceptionHandler;
    }

    protected AuthorizationRequestManager getAuthorizationRequestManager() {
        return this.authorizationRequestManager;
    }

    protected AuthorizationRequestManager getDefaultAuthorizationRequestManager() {
        return this.defaultAuthorizationRequestManager;
    }

    public void setAuthorizationRequestManager(AuthorizationRequestManager authorizationRequestManager) {
        this.authorizationRequestManager = authorizationRequestManager;
    }

    protected ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }
}

