/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.BadClientCredentialsException;
import org.springframework.security.oauth2.common.exceptions.ClientAuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.common.exceptions.UnapprovedClientAuthenticationException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedResponseTypeException;
import org.springframework.security.oauth2.common.exceptions.UserDeniedAuthorizationException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.approval.DefaultUserApprovalHandler;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.AuthorizationRequestHolder;
import org.springframework.security.oauth2.provider.code.InMemoryAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.endpoint.AbstractEndpoint;
import org.springframework.security.oauth2.provider.endpoint.DefaultRedirectResolver;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpoint;
import org.springframework.security.oauth2.provider.endpoint.RedirectResolver;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FrameworkEndpoint
@SessionAttributes(value={"authorizationRequest"})
@RequestMapping(value={"/oauth/authorize"})
public class AuthorizationEndpoint
extends AbstractEndpoint
implements InitializingBean {
    private AuthorizationCodeServices authorizationCodeServices = new InMemoryAuthorizationCodeServices();
    private RedirectResolver redirectResolver = new DefaultRedirectResolver();
    private UserApprovalHandler userApprovalHandler = new DefaultUserApprovalHandler();
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private String userApprovalPage = "forward:/oauth/confirm_access";
    private String errorPage = "forward:/oauth/error";

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
    }

    public void setSessionAttributeStore(SessionAttributeStore sessionAttributeStore) {
        this.sessionAttributeStore = sessionAttributeStore;
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    @RequestMapping
    public ModelAndView authorize(Map<String, Object> model, @RequestParam(value="response_type", required=false, defaultValue="none") String responseType, @RequestParam Map<String, String> parameters, SessionStatus sessionStatus, Principal principal) {
        Set<String> responseTypes = OAuth2Utils.parseParameterList(responseType);
        if (!responseTypes.contains("token") && !responseTypes.contains("code")) {
            throw new UnsupportedResponseTypeException("Unsupported response types: " + responseTypes);
        }
        try {
            DefaultAuthorizationRequest incomingRequest = new DefaultAuthorizationRequest(this.getAuthorizationRequestManager().createAuthorizationRequest(parameters));
            if (!(principal instanceof Authentication) || !((Authentication)principal).isAuthenticated()) {
                throw new InsufficientAuthenticationException("User must be authenticated with Spring Security before authorization can be completed.");
            }
            AuthorizationRequest outgoingRequest = this.resolveRedirectUriAndCheckApproval(incomingRequest, (Authentication)principal);
            this.getAuthorizationRequestManager().validateParameters(parameters, this.getClientDetailsService().loadClientByClientId(outgoingRequest.getClientId()));
            if (outgoingRequest.isApproved()) {
                if (responseTypes.contains("token")) {
                    return this.getImplicitGrantResponse(outgoingRequest);
                }
                if (responseTypes.contains("code")) {
                    return new ModelAndView(this.getAuthorizationCodeResponse(outgoingRequest, (Authentication)principal));
                }
            }
            model.put("authorizationRequest", outgoingRequest);
            return this.getUserApprovalPageResponse(model, outgoingRequest);
        }
        catch (RuntimeException e) {
            sessionStatus.setComplete();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, params={"user_oauth_approval"})
    public View approveOrDeny(@RequestParam Map<String, String> approvalParameters, Map<String, ?> model, SessionStatus sessionStatus, Principal principal) {
        if (!(principal instanceof Authentication)) {
            sessionStatus.setComplete();
            throw new InsufficientAuthenticationException("User must be authenticated with Spring Security before authorizing an access token.");
        }
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)model.get("authorizationRequest");
        if (authorizationRequest == null) {
            sessionStatus.setComplete();
            throw new InvalidRequestException("Cannot approve uninitialized authorization request.");
        }
        try {
            Set<String> responseTypes = authorizationRequest.getResponseTypes();
            DefaultAuthorizationRequest incomingRequest = new DefaultAuthorizationRequest(authorizationRequest);
            incomingRequest.setApprovalParameters(approvalParameters);
            AuthorizationRequest outgoingRequest = this.resolveRedirectUriAndCheckApproval(incomingRequest, (Authentication)principal);
            if (!outgoingRequest.isApproved()) {
                RedirectView redirectView = new RedirectView(this.getUnsuccessfulRedirect(outgoingRequest, new UserDeniedAuthorizationException("User denied access"), responseTypes.contains("token")), false);
                return redirectView;
            }
            if (responseTypes.contains("token")) {
                View view = this.getImplicitGrantResponse(outgoingRequest).getView();
                return view;
            }
            View view = this.getAuthorizationCodeResponse(outgoingRequest, (Authentication)principal);
            return view;
        }
        finally {
            sessionStatus.setComplete();
        }
    }

    private AuthorizationRequest resolveRedirectUriAndCheckApproval(AuthorizationRequest authorizationRequest, Authentication authentication) throws OAuth2Exception {
        String redirectUriParameter = authorizationRequest.getAuthorizationParameters().get("redirect_uri");
        String resolvedRedirect = this.redirectResolver.resolveRedirect(redirectUriParameter, this.getClientDetailsService().loadClientByClientId(authorizationRequest.getClientId()));
        if (!StringUtils.hasText(resolvedRedirect)) {
            throw new RedirectMismatchException("A redirectUri must be either supplied or preconfigured in the ClientDetails");
        }
        DefaultAuthorizationRequest requestForApproval = new DefaultAuthorizationRequest(authorizationRequest);
        requestForApproval.setRedirectUri(resolvedRedirect);
        DefaultAuthorizationRequest outgoingRequest = new DefaultAuthorizationRequest(this.userApprovalHandler.updateBeforeApproval(requestForApproval, authentication));
        boolean approved = authorizationRequest.isApproved();
        if (!approved) {
            approved = this.userApprovalHandler.isApproved(outgoingRequest, authentication);
            outgoingRequest.setApproved(approved);
        }
        return outgoingRequest;
    }

    private ModelAndView getUserApprovalPageResponse(Map<String, Object> model, AuthorizationRequest authorizationRequest) {
        this.logger.debug("Loading user approval page: " + this.userApprovalPage);
        model.putAll(authorizationRequest.getAuthorizationParameters());
        return new ModelAndView(this.userApprovalPage, model);
    }

    private ModelAndView getImplicitGrantResponse(AuthorizationRequest authorizationRequest) {
        try {
            OAuth2AccessToken accessToken = this.getTokenGranter().grant("implicit", authorizationRequest);
            if (accessToken == null) {
                throw new UnsupportedResponseTypeException("Unsupported response type: token");
            }
            return new ModelAndView(new RedirectView(this.appendAccessToken(authorizationRequest, accessToken), false));
        }
        catch (OAuth2Exception e) {
            return new ModelAndView(new RedirectView(this.getUnsuccessfulRedirect(authorizationRequest, e, true), false));
        }
    }

    private View getAuthorizationCodeResponse(AuthorizationRequest authorizationRequest, Authentication authUser) {
        try {
            return new RedirectView(this.getSuccessfulRedirect(authorizationRequest, this.generateCode(authorizationRequest, authUser)), false);
        }
        catch (OAuth2Exception e) {
            return new RedirectView(this.getUnsuccessfulRedirect(authorizationRequest, e, false), false);
        }
    }

    private String appendAccessToken(AuthorizationRequest authorizationRequest, OAuth2AccessToken accessToken) {
        Date expiration;
        String requestedRedirect = authorizationRequest.getRedirectUri();
        if (accessToken == null) {
            throw new InvalidGrantException("An implicit grant could not be made");
        }
        StringBuilder url = new StringBuilder(requestedRedirect);
        if (requestedRedirect.contains("#")) {
            url.append("&");
        } else {
            url.append("#");
        }
        url.append("access_token=" + accessToken.getValue());
        url.append("&token_type=" + accessToken.getTokenType());
        String state = authorizationRequest.getState();
        if (state != null) {
            url.append("&state=" + state);
        }
        if ((expiration = accessToken.getExpiration()) != null) {
            long expires_in = (expiration.getTime() - System.currentTimeMillis()) / 1000L;
            url.append("&expires_in=" + expires_in);
        }
        Map<String, Object> additionalInformation = accessToken.getAdditionalInformation();
        for (String key : additionalInformation.keySet()) {
            Object value = additionalInformation.get(key);
            if (value == null) continue;
            url.append("&" + key + "=" + value);
        }
        return url.toString();
    }

    private String generateCode(AuthorizationRequest authorizationRequest, Authentication authentication) throws AuthenticationException {
        try {
            AuthorizationRequestHolder combinedAuth = new AuthorizationRequestHolder(authorizationRequest, authentication);
            String code = this.authorizationCodeServices.createAuthorizationCode(combinedAuth);
            return code;
        }
        catch (OAuth2Exception e) {
            if (authorizationRequest.getState() != null) {
                e.addAdditionalInformation("state", authorizationRequest.getState());
            }
            throw e;
        }
    }

    private String getSuccessfulRedirect(AuthorizationRequest authorizationRequest, String authorizationCode) {
        if (authorizationCode == null) {
            throw new IllegalStateException("No authorization code found in the current request scope.");
        }
        String requestedRedirect = authorizationRequest.getRedirectUri();
        String[] fragments = requestedRedirect.split("#");
        String state = authorizationRequest.getState();
        StringBuilder url = new StringBuilder(fragments[0]);
        if (requestedRedirect.indexOf(63) < 0) {
            url.append('?');
        } else {
            url.append('&');
        }
        url.append("code=").append(authorizationCode);
        if (state != null) {
            url.append("&state=").append(state);
        }
        if (fragments.length > 1) {
            url.append("#" + fragments[1]);
        }
        return url.toString();
    }

    private String getUnsuccessfulRedirect(AuthorizationRequest authorizationRequest, OAuth2Exception failure, boolean fragment) {
        char separator;
        if (authorizationRequest == null || authorizationRequest.getRedirectUri() == null) {
            throw new UnapprovedClientAuthenticationException("Authorization failure, and no redirect URI.", failure);
        }
        String redirectUri = authorizationRequest.getRedirectUri();
        String[] fragments = redirectUri.split("#");
        StringBuilder url = new StringBuilder(fragment ? redirectUri : fragments[0]);
        char c = separator = fragment ? (char)'#' : '?';
        if (redirectUri.indexOf(separator) < 0) {
            url.append(separator);
        } else {
            url.append('&');
        }
        url.append("error=").append(failure.getOAuth2ErrorCode());
        try {
            url.append("&error_description=").append(URLEncoder.encode(failure.getMessage(), "UTF-8"));
            if (authorizationRequest.getState() != null) {
                url.append('&').append("state=").append(authorizationRequest.getState());
            }
            if (failure.getAdditionalInformation() != null) {
                for (Map.Entry<String, String> additionalInfo : failure.getAdditionalInformation().entrySet()) {
                    url.append('&').append(additionalInfo.getKey()).append('=').append(URLEncoder.encode(additionalInfo.getValue(), "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        if (!fragment && fragments.length > 1) {
            url.append("#" + fragments[1]);
        }
        return url.toString();
    }

    public void setUserApprovalPage(String userApprovalPage) {
        this.userApprovalPage = userApprovalPage;
    }

    public void setAuthorizationCodeServices(AuthorizationCodeServices authorizationCodeServices) {
        this.authorizationCodeServices = authorizationCodeServices;
    }

    public void setRedirectResolver(RedirectResolver redirectResolver) {
        this.redirectResolver = redirectResolver;
    }

    public void setUserApprovalHandler(UserApprovalHandler userApprovalHandler) {
        this.userApprovalHandler = userApprovalHandler;
    }

    @ExceptionHandler(value={NoSuchClientException.class})
    public ModelAndView handleNoSuchClientException(Exception e, ServletWebRequest webRequest) throws Exception {
        this.logger.info("Handling NoSuchClientException error: " + e.getMessage());
        return this.handleException(new BadClientCredentialsException(), webRequest);
    }

    @ExceptionHandler(value={OAuth2Exception.class})
    public ModelAndView handleOAuth2Exception(OAuth2Exception e, ServletWebRequest webRequest) throws Exception {
        this.logger.info("Handling OAuth2 error: " + e.getSummary());
        return this.handleException(e, webRequest);
    }

    @ExceptionHandler(value={HttpSessionRequiredException.class})
    public ModelAndView handleHttpSessionRequiredException(HttpSessionRequiredException e, ServletWebRequest webRequest) throws Exception {
        this.logger.info("Handling Session required error: " + e.getMessage());
        return this.handleException(new AccessDeniedException("Could not obtain authorization request from session", e), webRequest);
    }

    private ModelAndView handleException(Exception e, ServletWebRequest webRequest) throws Exception {
        ResponseEntity<OAuth2Exception> translate = this.getExceptionTranslator().translate(e);
        webRequest.getResponse().setStatus(translate.getStatusCode().value());
        if (e instanceof ClientAuthenticationException || e instanceof RedirectMismatchException) {
            return new ModelAndView(this.errorPage, Collections.singletonMap("error", translate.getBody()));
        }
        AuthorizationRequest errorRequest = null;
        try {
            errorRequest = this.getAuthorizationRequestForError(webRequest);
            DefaultAuthorizationRequest authorizationRequest = new DefaultAuthorizationRequest(errorRequest);
            String requestedRedirectParam = authorizationRequest.getAuthorizationParameters().get("redirect_uri");
            String requestedRedirect = this.redirectResolver.resolveRedirect(requestedRedirectParam, this.getClientDetailsService().loadClientByClientId(authorizationRequest.getClientId()));
            authorizationRequest.setRedirectUri(requestedRedirect);
            String redirect = this.getUnsuccessfulRedirect(authorizationRequest, (OAuth2Exception)translate.getBody(), authorizationRequest.getResponseTypes().contains("token"));
            return new ModelAndView(new RedirectView(redirect, false));
        }
        catch (OAuth2Exception ex) {
            return new ModelAndView(this.errorPage, Collections.singletonMap("error", translate.getBody()));
        }
    }

    private AuthorizationRequest getAuthorizationRequestForError(ServletWebRequest webRequest) {
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)this.sessionAttributeStore.retrieveAttribute(webRequest, "authorizationRequest");
        if (authorizationRequest != null) {
            return authorizationRequest;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String[]> map = webRequest.getParameterMap();
        for (String key : map.keySet()) {
            String[] values = map.get(key);
            if (values == null || values.length <= 0) continue;
            parameters.put(key, values[0]);
        }
        try {
            return this.getAuthorizationRequestManager().createAuthorizationRequest(parameters);
        }
        catch (Exception e) {
            return this.getDefaultAuthorizationRequestManager().createAuthorizationRequest(parameters);
        }
    }
}

