/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpoint;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FrameworkEndpoint
@SessionAttributes(value={"authorizationRequest"})
public class WhitelabelApprovalEndpoint {
    private static String APPROVAL = "<html><body><h1>OAuth Approval</h1><p>Do you authorize '${authorizationRequest.clientId}' to access your protected resources?</p><form id='confirmationForm' name='confirmationForm' action='${path}/oauth/authorize' method='post'><input name='user_oauth_approval' value='true' type='hidden'/><label><input name='authorize' value='Authorize' type='submit'></label></form><form id='denialForm' name='denialForm' action='${path}/oauth/authorize' method='post'><input name='user_oauth_approval' value='false' type='hidden'/><label><input name='deny' value='Deny' type='submit'></label></form></body></html>";
    private static String ERROR = "<html><body><h1>OAuth Error</h1><p>${error.summary}</p></body></html>";

    @RequestMapping(value={"/oauth/confirm_access"})
    public ModelAndView getAccessConfirmation(Map<String, Object> model) throws Exception {
        return new ModelAndView(new SpelView(APPROVAL), model);
    }

    @RequestMapping(value={"/oauth/error"})
    public ModelAndView handleError(HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("error", request.getAttribute("error"));
        return new ModelAndView(new SpelView(ERROR), model);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpelView
    implements View {
        private final String template;
        private final SpelExpressionParser parser = new SpelExpressionParser();
        private final StandardEvaluationContext context = new StandardEvaluationContext();
        private PropertyPlaceholderHelper helper;
        private PropertyPlaceholderHelper.PlaceholderResolver resolver;

        public SpelView(String template) {
            this.template = template;
            this.context.addPropertyAccessor(new MapAccessor());
            this.helper = new PropertyPlaceholderHelper("${", "}");
            this.resolver = new PropertyPlaceholderHelper.PlaceholderResolver(){

                public String resolvePlaceholder(String name) {
                    Expression expression = SpelView.this.parser.parseExpression(name);
                    Object value = expression.getValue(SpelView.this.context);
                    return value == null ? null : value.toString();
                }
            };
        }

        @Override
        public String getContentType() {
            return "text/html";
        }

        @Override
        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            HashMap map = new HashMap(model);
            map.put("path", request.getContextPath());
            this.context.setRootObject(map);
            String result = this.helper.replacePlaceholders(this.template, this.resolver);
            response.getWriter().append(result);
        }
    }
}

