/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public abstract class AbstractTokenGranter
implements TokenGranter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final AuthorizationServerTokenServices tokenServices;
    private final ClientDetailsService clientDetailsService;
    private final String grantType;

    protected AbstractTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, String grantType) {
        this.clientDetailsService = clientDetailsService;
        this.grantType = grantType;
        this.tokenServices = tokenServices;
    }

    public OAuth2AccessToken grant(String grantType, AuthorizationRequest authorizationRequest) {
        if (!this.grantType.equals(grantType)) {
            return null;
        }
        String clientId = authorizationRequest.getClientId();
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
        this.validateGrantType(grantType, client);
        this.logger.debug("Getting access token for: " + clientId);
        return this.getAccessToken(authorizationRequest);
    }

    protected OAuth2AccessToken getAccessToken(AuthorizationRequest authorizationRequest) {
        DefaultAuthorizationRequest outgoingRequest = new DefaultAuthorizationRequest(authorizationRequest);
        outgoingRequest.setApproved(true);
        return this.tokenServices.createAccessToken(this.getOAuth2Authentication(outgoingRequest));
    }

    protected OAuth2Authentication getOAuth2Authentication(AuthorizationRequest authorizationRequest) {
        return new OAuth2Authentication(authorizationRequest, null);
    }

    protected void validateGrantType(String grantType, ClientDetails clientDetails) {
        Set<String> authorizedGrantTypes = clientDetails.getAuthorizedGrantTypes();
        if (authorizedGrantTypes != null && !authorizedGrantTypes.isEmpty() && !authorizedGrantTypes.contains(grantType)) {
            throw new InvalidGrantException("Unauthorized grant type: " + grantType);
        }
    }

    protected AuthorizationServerTokenServices getTokenServices() {
        return this.tokenServices;
    }
}

