/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.context.request.WebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAttributesHandler {
    private final Set<String> attributeNames = new HashSet<String>();
    private final Set<Class<?>> attributeTypes = new HashSet();
    private final Map<String, Boolean> knownAttributeNames = new ConcurrentHashMap<String, Boolean>(4);
    private final SessionAttributeStore sessionAttributeStore;

    public SessionAttributesHandler(Class<?> handlerType, SessionAttributeStore sessionAttributeStore) {
        Assert.notNull(sessionAttributeStore, "SessionAttributeStore may not be null.");
        this.sessionAttributeStore = sessionAttributeStore;
        SessionAttributes annotation = AnnotationUtils.findAnnotation(handlerType, SessionAttributes.class);
        if (annotation != null) {
            this.attributeNames.addAll(Arrays.asList(annotation.value()));
            this.attributeTypes.addAll(Arrays.asList(annotation.types()));
        }
        for (String attributeName : this.attributeNames) {
            this.knownAttributeNames.put(attributeName, Boolean.TRUE);
        }
    }

    public boolean hasSessionAttributes() {
        return this.attributeNames.size() > 0 || this.attributeTypes.size() > 0;
    }

    public boolean isHandlerSessionAttribute(String attributeName, Class<?> attributeType) {
        Assert.notNull(attributeName, "Attribute name must not be null");
        if (this.attributeNames.contains(attributeName) || this.attributeTypes.contains(attributeType)) {
            this.knownAttributeNames.put(attributeName, Boolean.TRUE);
            return true;
        }
        return false;
    }

    public void storeAttributes(WebRequest request, Map<String, ?> attributes) {
        Iterator<String> i$ = attributes.keySet().iterator();
        while (i$.hasNext()) {
            String name;
            Object value = attributes.get(name = i$.next());
            Class<?> attrType = value != null ? value.getClass() : null;
            if (!this.isHandlerSessionAttribute(name, attrType)) continue;
            this.sessionAttributeStore.storeAttribute(request, name, value);
        }
    }

    public Map<String, Object> retrieveAttributes(WebRequest request) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (String name : this.knownAttributeNames.keySet()) {
            Object value = this.sessionAttributeStore.retrieveAttribute(request, name);
            if (value == null) continue;
            attributes.put(name, value);
        }
        return attributes;
    }

    public void cleanupAttributes(WebRequest request) {
        for (String attributeName : this.knownAttributeNames.keySet()) {
            this.sessionAttributeStore.cleanupAttribute(request, attributeName);
        }
    }

    Object retrieveAttribute(WebRequest request, String attributeName) {
        return this.sessionAttributeStore.retrieveAttribute(request, attributeName);
    }
}

