/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.servlet.mvc.condition.AbstractMediaTypeExpression;
import org.springframework.web.servlet.mvc.condition.AbstractRequestCondition;
import org.springframework.web.servlet.mvc.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.condition.MediaTypeExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsumesRequestCondition
extends AbstractRequestCondition<ConsumesRequestCondition> {
    private final List<ConsumeMediaTypeExpression> expressions;

    public ConsumesRequestCondition(String ... consumes) {
        this(consumes, (String[])null);
    }

    public ConsumesRequestCondition(String[] consumes, String[] headers) {
        this(ConsumesRequestCondition.parseExpressions(consumes, headers));
    }

    private ConsumesRequestCondition(Collection<ConsumeMediaTypeExpression> expressions) {
        this.expressions = new ArrayList<ConsumeMediaTypeExpression>(expressions);
        Collections.sort(this.expressions);
    }

    private static Set<ConsumeMediaTypeExpression> parseExpressions(String[] consumes, String[] headers) {
        LinkedHashSet<ConsumeMediaTypeExpression> result = new LinkedHashSet<ConsumeMediaTypeExpression>();
        if (headers != null) {
            for (String header : headers) {
                HeadersRequestCondition.HeaderExpression expr = new HeadersRequestCondition.HeaderExpression(header);
                if (!"Content-Type".equalsIgnoreCase(expr.name)) continue;
                for (MediaType mediaType : MediaType.parseMediaTypes((String)expr.value)) {
                    result.add(new ConsumeMediaTypeExpression(mediaType, expr.isNegated));
                }
            }
        }
        if (consumes != null) {
            for (String consume : consumes) {
                result.add(new ConsumeMediaTypeExpression(consume));
            }
        }
        return result;
    }

    public Set<MediaTypeExpression> getExpressions() {
        return new LinkedHashSet<MediaTypeExpression>(this.expressions);
    }

    public Set<MediaType> getConsumableMediaTypes() {
        LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
        for (ConsumeMediaTypeExpression expression : this.expressions) {
            if (expression.isNegated()) continue;
            result.add(expression.getMediaType());
        }
        return result;
    }

    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    @Override
    protected Collection<ConsumeMediaTypeExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public ConsumesRequestCondition combine(ConsumesRequestCondition other) {
        return !other.expressions.isEmpty() ? other : this;
    }

    @Override
    public ConsumesRequestCondition getMatchingCondition(HttpServletRequest request) {
        if (this.isEmpty()) {
            return this;
        }
        LinkedHashSet<ConsumeMediaTypeExpression> result = new LinkedHashSet<ConsumeMediaTypeExpression>(this.expressions);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            ConsumeMediaTypeExpression expression = (ConsumeMediaTypeExpression)iterator.next();
            if (expression.match(request)) continue;
            iterator.remove();
        }
        return result.isEmpty() ? null : new ConsumesRequestCondition(result);
    }

    @Override
    public int compareTo(ConsumesRequestCondition other, HttpServletRequest request) {
        if (this.expressions.isEmpty() && other.expressions.isEmpty()) {
            return 0;
        }
        if (this.expressions.isEmpty()) {
            return 1;
        }
        if (other.expressions.isEmpty()) {
            return -1;
        }
        return this.expressions.get(0).compareTo(other.expressions.get(0));
    }

    static class ConsumeMediaTypeExpression
    extends AbstractMediaTypeExpression {
        ConsumeMediaTypeExpression(String expression) {
            super(expression);
        }

        ConsumeMediaTypeExpression(MediaType mediaType, boolean negated) {
            super(mediaType, negated);
        }

        protected boolean matchMediaType(HttpServletRequest request) throws HttpMediaTypeNotSupportedException {
            try {
                MediaType contentType = StringUtils.hasLength(request.getContentType()) ? MediaType.parseMediaType(request.getContentType()) : MediaType.APPLICATION_OCTET_STREAM;
                return this.getMediaType().includes(contentType);
            }
            catch (IllegalArgumentException ex) {
                throw new HttpMediaTypeNotSupportedException("Can't parse Content-Type [" + request.getContentType() + "]: " + ex.getMessage());
            }
        }
    }
}

