/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodArgumentResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageConverterMethodProcessor
extends AbstractMessageConverterMethodArgumentResolver
implements HandlerMethodReturnValueHandler {
    private static final MediaType MEDIA_TYPE_APPLICATION = new MediaType("application");
    private final ContentNegotiationManager contentNegotiationManager;

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> messageConverters) {
        this(messageConverters, null);
    }

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> messageConverters, ContentNegotiationManager manager) {
        super(messageConverters);
        this.contentNegotiationManager = manager != null ? manager : new ContentNegotiationManager();
    }

    protected ServletServerHttpResponse createOutputMessage(NativeWebRequest webRequest) {
        HttpServletResponse response = webRequest.getNativeResponse(HttpServletResponse.class);
        return new ServletServerHttpResponse(response);
    }

    protected <T> void writeWithMessageConverters(T returnValue, MethodParameter returnType, NativeWebRequest webRequest) throws IOException, HttpMediaTypeNotAcceptableException {
        ServletServerHttpRequest inputMessage = this.createInputMessage(webRequest);
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        this.writeWithMessageConverters(returnValue, returnType, inputMessage, outputMessage);
    }

    protected <T> void writeWithMessageConverters(T returnValue, MethodParameter returnType, ServletServerHttpRequest inputMessage, ServletServerHttpResponse outputMessage) throws IOException, HttpMediaTypeNotAcceptableException {
        Class<?> returnValueClass = returnValue.getClass();
        HttpServletRequest servletRequest = inputMessage.getServletRequest();
        List<MediaType> requestedMediaTypes = this.getAcceptableMediaTypes(servletRequest);
        List<MediaType> producibleMediaTypes = this.getProducibleMediaTypes(servletRequest, returnValueClass);
        LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
        for (MediaType r : requestedMediaTypes) {
            for (MediaType p : producibleMediaTypes) {
                if (!r.isCompatibleWith(p)) continue;
                compatibleMediaTypes.add(this.getMostSpecificMediaType(r, p));
            }
        }
        if (compatibleMediaTypes.isEmpty()) {
            throw new HttpMediaTypeNotAcceptableException(producibleMediaTypes);
        }
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(compatibleMediaTypes);
        MediaType.sortBySpecificityAndQuality(mediaTypes);
        MediaType selectedMediaType = null;
        for (MediaType mediaType : mediaTypes) {
            if (mediaType.isConcrete()) {
                selectedMediaType = mediaType;
                break;
            }
            if (!mediaType.equals(MediaType.ALL) && !mediaType.equals(MEDIA_TYPE_APPLICATION)) continue;
            selectedMediaType = MediaType.APPLICATION_OCTET_STREAM;
            break;
        }
        if (selectedMediaType != null) {
            selectedMediaType = selectedMediaType.removeQualityValue();
            for (HttpMessageConverter messageConverter : this.messageConverters) {
                if (!messageConverter.canWrite(returnValueClass, selectedMediaType)) continue;
                messageConverter.write(returnValue, selectedMediaType, outputMessage);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Written [" + returnValue + "] as \"" + selectedMediaType + "\" using [" + messageConverter + "]");
                }
                return;
            }
        }
        throw new HttpMediaTypeNotAcceptableException(this.allSupportedMediaTypes);
    }

    protected List<MediaType> getProducibleMediaTypes(HttpServletRequest request, Class<?> returnValueClass) {
        Set mediaTypes = (Set)request.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        if (!CollectionUtils.isEmpty(mediaTypes)) {
            return new ArrayList<MediaType>(mediaTypes);
        }
        if (!this.allSupportedMediaTypes.isEmpty()) {
            ArrayList<MediaType> result = new ArrayList<MediaType>();
            for (HttpMessageConverter converter : this.messageConverters) {
                if (!converter.canWrite(returnValueClass, null)) continue;
                result.addAll(converter.getSupportedMediaTypes());
            }
            return result;
        }
        return Collections.singletonList(MediaType.ALL);
    }

    private List<MediaType> getAcceptableMediaTypes(HttpServletRequest request) throws HttpMediaTypeNotAcceptableException {
        List<MediaType> mediaTypes = this.contentNegotiationManager.resolveMediaTypes(new ServletWebRequest(request));
        return mediaTypes.isEmpty() ? Collections.singletonList(MediaType.ALL) : mediaTypes;
    }

    private MediaType getMostSpecificMediaType(MediaType acceptType, MediaType produceType) {
        return MediaType.SPECIFICITY_COMPARATOR.compare(acceptType, produceType = produceType.copyQualityValue(acceptType)) <= 0 ? acceptType : produceType;
    }
}

