/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.util.Collection;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.form.AbstractCheckedElementTag;
import org.springframework.web.servlet.tags.form.TagIdGenerator;
import org.springframework.web.servlet.tags.form.TagWriter;

public abstract class AbstractMultiCheckedElementTag
extends AbstractCheckedElementTag {
    private static final String SPAN_TAG = "span";
    private Object items;
    private String itemValue;
    private String itemLabel;
    private String element = "span";
    private String delimiter;

    public void setItems(Object items) {
        Assert.notNull(items, "'items' must not be null");
        this.items = items;
    }

    protected Object getItems() {
        return this.items;
    }

    public void setItemValue(String itemValue) {
        Assert.hasText(itemValue, "'itemValue' must not be empty");
        this.itemValue = itemValue;
    }

    protected String getItemValue() {
        return this.itemValue;
    }

    public void setItemLabel(String itemLabel) {
        Assert.hasText(itemLabel, "'itemLabel' must not be empty");
        this.itemLabel = itemLabel;
    }

    protected String getItemLabel() {
        return this.itemLabel;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setElement(String element) {
        Assert.hasText(element, "'element' cannot be null or blank");
        this.element = element;
    }

    public String getElement() {
        return this.element;
    }

    protected String resolveId() throws JspException {
        Object id = this.evaluate("id", this.getId());
        if (id != null) {
            String idString = id.toString();
            return StringUtils.hasText(idString) ? TagIdGenerator.nextId(idString, this.pageContext) : null;
        }
        return this.autogenerateId();
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        T[] items = this.getItems();
        T[] itemsObject = items instanceof String ? this.evaluate("items", items) : items;
        String itemValue = this.getItemValue();
        String itemLabel = this.getItemLabel();
        String valueProperty = itemValue != null ? ObjectUtils.getDisplayString(this.evaluate("itemValue", itemValue)) : null;
        String labelProperty = itemLabel != null ? ObjectUtils.getDisplayString(this.evaluate("itemLabel", itemLabel)) : null;
        Class boundType = this.getBindStatus().getValueType();
        if (itemsObject == null && boundType != null && boundType.isEnum()) {
            itemsObject = boundType.getEnumConstants();
        }
        if (itemsObject == null) {
            throw new IllegalArgumentException("Attribute 'items' is required and must be a Collection, an Array or a Map");
        }
        if (itemsObject.getClass().isArray()) {
            T[] itemsArray = itemsObject;
            for (int i = 0; i < itemsArray.length; ++i) {
                Object item = itemsArray[i];
                this.writeObjectEntry(tagWriter, valueProperty, labelProperty, item, i);
            }
        } else if (itemsObject instanceof Collection) {
            Collection optionCollection = (Collection)itemsObject;
            int itemIndex = 0;
            for (Object item : optionCollection) {
                this.writeObjectEntry(tagWriter, valueProperty, labelProperty, item, itemIndex);
                ++itemIndex;
            }
        } else if (itemsObject instanceof Map) {
            Map optionMap = (Map)itemsObject;
            int itemIndex = 0;
            for (Map.Entry entry : optionMap.entrySet()) {
                this.writeMapEntry(tagWriter, valueProperty, labelProperty, entry, itemIndex);
                ++itemIndex;
            }
        } else {
            throw new IllegalArgumentException("Attribute 'items' must be an array, a Collection or a Map");
        }
        return 0;
    }

    private void writeObjectEntry(TagWriter tagWriter, String valueProperty, String labelProperty, Object item, int itemIndex) throws JspException {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess(item);
        Object renderValue = valueProperty != null ? wrapper.getPropertyValue(valueProperty) : (item instanceof Enum ? ((Enum)item).name() : item);
        Object renderLabel = labelProperty != null ? wrapper.getPropertyValue(labelProperty) : item;
        this.writeElementTag(tagWriter, item, renderValue, renderLabel, itemIndex);
    }

    private void writeMapEntry(TagWriter tagWriter, String valueProperty, String labelProperty, Map.Entry entry, int itemIndex) throws JspException {
        Object mapKey = entry.getKey();
        Object mapValue = entry.getValue();
        BeanWrapper mapKeyWrapper = PropertyAccessorFactory.forBeanPropertyAccess(mapKey);
        BeanWrapper mapValueWrapper = PropertyAccessorFactory.forBeanPropertyAccess(mapValue);
        Object renderValue = valueProperty != null ? mapKeyWrapper.getPropertyValue(valueProperty) : mapKey.toString();
        Object renderLabel = labelProperty != null ? mapValueWrapper.getPropertyValue(labelProperty) : mapValue.toString();
        this.writeElementTag(tagWriter, mapKey, renderValue, renderLabel, itemIndex);
    }

    private void writeElementTag(TagWriter tagWriter, Object item, Object value, Object label, int itemIndex) throws JspException {
        Object resolvedDelimiter;
        tagWriter.startTag(this.getElement());
        if (itemIndex > 0 && (resolvedDelimiter = this.evaluate("delimiter", this.getDelimiter())) != null) {
            tagWriter.appendValue(resolvedDelimiter.toString());
        }
        tagWriter.startTag("input");
        String id = this.resolveId();
        this.writeOptionalAttribute(tagWriter, "id", id);
        this.writeOptionalAttribute(tagWriter, "name", this.getName());
        this.writeOptionalAttributes(tagWriter);
        tagWriter.writeAttribute("type", this.getInputType());
        this.renderFromValue(item, value, tagWriter);
        tagWriter.endTag();
        tagWriter.startTag("label");
        tagWriter.writeAttribute("for", id);
        tagWriter.appendValue(this.convertToDisplayString(label));
        tagWriter.endTag();
        tagWriter.endTag();
    }
}

