/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.flux.client.CallbackIDAwareMessageHandler;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.json.JSONArray;
import org.json.JSONObject;

public class DownloadProject {
    private MessageConnector messagingConnector;
    private String projectName;
    private int callbackID;
    private CompletionCallback completionCallback;
    private String username;
    private IProject project;
    private Set<String> requestedProjectFiles = new ConcurrentSkipListSet<String>();
    private Set<String> projectFiles = new ConcurrentSkipListSet<String>();
    private CallbackIDAwareMessageHandler projectResponseHandler;
    private CallbackIDAwareMessageHandler resourceResponseHandler;

    public DownloadProject(MessageConnector messagingConnector, String projectName, String username) {
        this.messagingConnector = messagingConnector;
        this.projectName = projectName;
        this.username = username;
        this.callbackID = this.hashCode();
        this.projectResponseHandler = new CallbackIDAwareMessageHandler("getProjectResponse", this.callbackID){

            public void handle(String messageType, JSONObject message) {
                DownloadProject.this.getProjectResponse(message);
            }
        };
        this.resourceResponseHandler = new CallbackIDAwareMessageHandler("getResourceResponse", this.callbackID){

            public void handle(String messageType, JSONObject message) {
                DownloadProject.this.getResourceResponse(message);
            }
        };
    }

    public void run(final CompletionCallback completionCallback) {
        this.messagingConnector.addMessageHandler((IMessageHandler)this.projectResponseHandler);
        this.messagingConnector.addMessageHandler((IMessageHandler)this.resourceResponseHandler);
        this.completionCallback = completionCallback;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project = root.getProject(this.projectName);
        WorkspaceJob job = new WorkspaceJob("createProject"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    if (!DownloadProject.this.project.exists()) {
                        DownloadProject.this.project.create(monitor);
                    }
                    if (!DownloadProject.this.project.isOpen()) {
                        DownloadProject.this.project.open(monitor);
                    }
                    JSONObject message = new JSONObject();
                    message.put("callback_id", DownloadProject.this.callbackID);
                    message.put("username", (Object)DownloadProject.this.username);
                    message.put("project", (Object)DownloadProject.this.projectName);
                    DownloadProject.this.messagingConnector.send("getProjectRequest", message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadProject.this.messagingConnector.removeMessageHandler((IMessageHandler)DownloadProject.this.projectResponseHandler);
                    DownloadProject.this.messagingConnector.removeMessageHandler((IMessageHandler)DownloadProject.this.resourceResponseHandler);
                    completionCallback.downloadFailed();
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().createRule((IResource)this.project));
        job.schedule();
    }

    public void getProjectResponse(JSONObject response) {
        try {
            String responseProject = response.getString("project");
            String responseUser = response.getString("username");
            JSONArray files = response.getJSONArray("files");
            if (this.username.equals(responseUser)) {
                HashSet<String> newFiles = new HashSet<String>();
                int i = 0;
                while (i < files.length()) {
                    boolean added;
                    JSONObject resource = files.getJSONObject(i);
                    String resourcePath = resource.getString("path");
                    long timestamp = resource.getLong("timestamp");
                    String type = resource.optString("type");
                    if (type.equals("folder")) {
                        if (!resourcePath.isEmpty()) {
                            IFolder folder = this.project.getFolder((IPath)new Path(resourcePath));
                            this.createFolder(folder);
                            folder.setLocalTimeStamp(timestamp);
                        }
                    } else if (type.equals("file") && (added = this.projectFiles.add(resourcePath))) {
                        newFiles.add(resourcePath);
                    }
                    ++i;
                }
                for (String resourcePath : newFiles) {
                    this.requestedProjectFiles.add(resourcePath);
                    JSONObject message = new JSONObject();
                    message.put("callback_id", this.callbackID);
                    message.put("username", (Object)this.username);
                    message.put("project", (Object)responseProject);
                    message.put("resource", (Object)resourcePath);
                    this.messagingConnector.send("getResourceRequest", message);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.messagingConnector.removeMessageHandler((IMessageHandler)this.projectResponseHandler);
            this.messagingConnector.removeMessageHandler((IMessageHandler)this.resourceResponseHandler);
            this.completionCallback.downloadFailed();
        }
    }

    private void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                this.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }

    public void getResourceResponse(JSONObject response) {
        try {
            String responseUser = response.getString("username");
            String resourcePath = response.getString("resource");
            long timestamp = response.getLong("timestamp");
            String content = response.getString("content");
            if (this.username.equals(responseUser)) {
                IFile file = this.project.getFile(resourcePath);
                if (!file.exists()) {
                    file.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
                } else {
                    file.setContents((InputStream)new ByteArrayInputStream(content.getBytes()), true, false, null);
                }
                file.setLocalTimeStamp(timestamp);
                this.requestedProjectFiles.remove(resourcePath);
                if (this.requestedProjectFiles.isEmpty()) {
                    this.messagingConnector.removeMessageHandler((IMessageHandler)this.projectResponseHandler);
                    this.messagingConnector.removeMessageHandler((IMessageHandler)this.resourceResponseHandler);
                    this.finish();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.messagingConnector.removeMessageHandler((IMessageHandler)this.projectResponseHandler);
            this.messagingConnector.removeMessageHandler((IMessageHandler)this.resourceResponseHandler);
            this.completionCallback.downloadFailed();
        }
    }

    public void finish() {
        IFile pomFile;
        if (this.projectFiles.contains("pom.xml") && !this.projectFiles.contains(".project") && (pomFile = this.project.getFile("pom.xml")) != null && pomFile.exists()) {
            this.importAsPureMavenProject(pomFile);
        }
        this.completionCallback.downloadComplete(this.project);
    }

    private void importAsPureMavenProject(IFile pomFile) {
        WorkspaceJob job = new WorkspaceJob("importAsMaven"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    ResolverConfiguration resolverConfiguration = new ResolverConfiguration();
                    String activeProfiles = "pom.xml";
                    resolverConfiguration.setActiveProfiles(activeProfiles);
                    MavenPlugin.getProjectConfigurationManager().enableMavenNature(DownloadProject.this.project, resolverConfiguration, monitor);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return Status.OK_STATUS;
                }
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    public static interface CompletionCallback {
        public void downloadComplete(IProject var1);

        public void downloadFailed();
    }
}

