/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.MessageHandler;
import org.eclipse.flux.core.ILiveEditConnector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LiveEditCoordinator {
    private MessageConnector messagingConnector;
    private Collection<ILiveEditConnector> liveEditConnectors;
    private Collection<IMessageHandler> messageHandlers;

    public LiveEditCoordinator(MessageConnector messagingConnector) {
        this.messagingConnector = messagingConnector;
        this.liveEditConnectors = new CopyOnWriteArrayList<ILiveEditConnector>();
        this.messageHandlers = new ArrayList<IMessageHandler>(4);
        MessageHandler startLiveUnit = new MessageHandler("liveResourceStarted"){

            public void handle(String messageType, JSONObject message) {
                LiveEditCoordinator.this.startLiveUnit(message);
            }
        };
        messagingConnector.addMessageHandler((IMessageHandler)startLiveUnit);
        this.messageHandlers.add((IMessageHandler)startLiveUnit);
        MessageHandler startLiveUnitResponse = new MessageHandler("liveResourceStartedResponse"){

            public void handle(String messageType, JSONObject message) {
                LiveEditCoordinator.this.startLiveUnitResponse(message);
            }
        };
        messagingConnector.addMessageHandler((IMessageHandler)startLiveUnitResponse);
        this.messageHandlers.add((IMessageHandler)startLiveUnitResponse);
        MessageHandler modelChangedHandler = new MessageHandler("liveResourceChanged"){

            public void handle(String messageType, JSONObject message) {
                LiveEditCoordinator.this.modelChanged(message);
            }
        };
        messagingConnector.addMessageHandler((IMessageHandler)modelChangedHandler);
        this.messageHandlers.add((IMessageHandler)modelChangedHandler);
        MessageHandler liveUnits = new MessageHandler("getLiveResourcesRequest"){

            public void handle(String messageType, JSONObject message) {
                LiveEditCoordinator.this.sendLiveUnits(message);
            }
        };
        messagingConnector.addMessageHandler((IMessageHandler)liveUnits);
        this.messageHandlers.add((IMessageHandler)liveUnits);
    }

    protected void startLiveUnit(JSONObject message) {
        try {
            String requestSenderID = message.getString("requestSenderID");
            int callbackID = message.getInt("callback_id");
            String username = message.getString("username");
            String projectName = message.getString("project");
            String resourcePath = message.getString("resource");
            String hash = message.getString("hash");
            long timestamp = message.getLong("timestamp");
            String liveEditID = String.valueOf(projectName) + "/" + resourcePath;
            for (ILiveEditConnector connector : this.liveEditConnectors) {
                connector.liveEditingStarted(requestSenderID, callbackID, username, liveEditID, hash, timestamp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void startLiveUnitResponse(JSONObject message) {
        try {
            String requestSenderID = message.getString("requestSenderID");
            int callbackID = message.getInt("callback_id");
            String username = message.getString("username");
            String projectName = message.getString("project");
            String resourcePath = message.getString("resource");
            String savePointHash = message.getString("savePointHash");
            long savePointTimestamp = message.getLong("savePointTimestamp");
            String content = message.getString("liveContent");
            for (ILiveEditConnector connector : this.liveEditConnectors) {
                connector.liveEditingStartedResponse(requestSenderID, callbackID, username, projectName, resourcePath, savePointHash, savePointTimestamp, content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void modelChanged(JSONObject message) {
        try {
            String username = message.getString("username");
            String projectName = message.getString("project");
            String resourcePath = message.getString("resource");
            int offset = message.getInt("offset");
            int removedCharCount = message.getInt("removedCharCount");
            String addedChars = message.has("addedCharacters") ? message.getString("addedCharacters") : "";
            String liveEditID = String.valueOf(projectName) + "/" + resourcePath;
            for (ILiveEditConnector connector : this.liveEditConnectors) {
                connector.liveEditingEvent(username, liveEditID, offset, removedCharCount, addedChars);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void sendLiveUnits(JSONObject message) {
        try {
            String username = message.has("username") ? message.getString("username") : null;
            String requestSenderID = message.getString("requestSenderID");
            String projectRegEx = message.has("projectRegEx") ? message.getString("projectRegEx") : null;
            String resourceRegEx = message.has("resourceRegEx") ? message.getString("resourceRegEx") : null;
            int callbackID = message.getInt("callback_id");
            for (ILiveEditConnector connector : this.liveEditConnectors) {
                connector.liveEditors(requestSenderID, callbackID, username, projectRegEx, resourceRegEx);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addLiveEditConnector(ILiveEditConnector connector) {
        this.liveEditConnectors.add(connector);
    }

    public void removeLiveEditConnector(ILiveEditConnector connector) {
        this.liveEditConnectors.remove(connector);
    }

    public void sendModelChangedMessage(String changeOriginID, String username, String projectName, String resourcePath, int offset, int removedCharactersCount, String newText) {
        try {
            JSONObject message = new JSONObject();
            message.put("username", (Object)username);
            message.put("project", (Object)projectName);
            message.put("resource", (Object)resourcePath);
            message.put("offset", offset);
            message.put("offset", offset);
            message.put("removedCharCount", removedCharactersCount);
            message.put("addedCharacters", (Object)(newText != null ? newText : ""));
            this.messagingConnector.send("liveResourceChanged", message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String fullResourcePath = String.valueOf(projectName) + "/" + resourcePath;
        for (ILiveEditConnector connector : this.liveEditConnectors) {
            if (connector.getConnectorID().equals(changeOriginID)) continue;
            connector.liveEditingEvent(username, fullResourcePath, offset, removedCharactersCount, newText);
        }
    }

    public void sendLiveEditStartedMessage(String changeOriginID, String username, String projectName, String resourcePath, String hash, long timestamp) {
        try {
            JSONObject message = new JSONObject();
            message.put("callback_id", 0);
            message.put("username", (Object)username);
            message.put("project", (Object)projectName);
            message.put("resource", (Object)resourcePath);
            message.put("hash", (Object)hash);
            message.put("timestamp", timestamp);
            this.messagingConnector.send("liveResourceStarted", message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String path = String.valueOf(projectName) + '/' + resourcePath;
        for (ILiveEditConnector connector : this.liveEditConnectors) {
            if (connector.getConnectorID().equals(changeOriginID)) continue;
            connector.liveEditingStarted("local", 0, username, path, hash, timestamp);
        }
    }

    public void sendLiveEditStartedResponse(String responseOriginID, String requestSenderID, int callbackID, String username, String projectName, String resourcePath, String savePointHash, long savePointTimestamp, String content) {
        try {
            JSONObject message = new JSONObject();
            message.put("requestSenderID", (Object)requestSenderID);
            message.put("callback_id", callbackID);
            message.put("username", (Object)username);
            message.put("project", (Object)projectName);
            message.put("resource", (Object)resourcePath);
            message.put("savePointTimestamp", savePointTimestamp);
            message.put("savePointHash", (Object)savePointHash);
            message.put("liveContent", (Object)content);
            this.messagingConnector.send("liveResourceStartedResponse", message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ILiveEditConnector connector : this.liveEditConnectors) {
            if (connector.getConnectorID().equals(responseOriginID)) continue;
            connector.liveEditingStartedResponse(requestSenderID, callbackID, username, projectName, resourcePath, savePointHash, savePointTimestamp, content);
        }
    }

    public void sendLiveResourcesResponse(String requestSenderID, int callbackID, String username, Map<String, List<ResourceData>> liveUnits) {
        if (liveUnits.isEmpty()) {
            return;
        }
        try {
            JSONObject message = new JSONObject();
            message.put("requestSenderID", (Object)requestSenderID);
            message.put("callback_id", callbackID);
            message.put("username", (Object)username);
            JSONObject liveEditUnits = new JSONObject();
            for (Map.Entry<String, List<ResourceData>> entry : liveUnits.entrySet()) {
                liveEditUnits.put(entry.getKey(), (Object)new JSONArray((Collection)entry.getValue()));
            }
            message.put("liveEditUnits", (Object)liveEditUnits);
            this.messagingConnector.send("getLiveResourcesResponse", message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        for (IMessageHandler messageHanlder : this.messageHandlers) {
            this.messagingConnector.removeMessageHandler(messageHanlder);
        }
    }

    public static class ResourceData
    extends JSONObject {
        public ResourceData(String path, String hash, long timestamp) {
            try {
                this.put("resource", path);
                this.put("savePointHash", hash);
                this.put("savePointTimestamp", timestamp);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

