/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.ui.integration;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.flux.client.ConnectionStatus;
import org.eclipse.flux.client.util.Listener;
import org.eclipse.flux.client.util.Observable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.progress.UIJob;

public class AuthFailureReporter
implements Listener<ConnectionStatus> {
    private Observable<ConnectionStatus> state;

    public AuthFailureReporter(Observable<ConnectionStatus> observable) {
        this.state = observable;
        this.state.addListener((Listener)this);
    }

    public void newValue(Observable<ConnectionStatus> o, ConnectionStatus v) {
        if (v.isAuthFailure()) {
            UIJob job = new UIJob("Flux Error Reporter"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    MessageDialog.openError(null, (String)"Flux Connection Failed", (String)"Flux Web Socket handshake failed. Most likely this means your Flux credentials are invalid.");
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else if (v.isConnected()) {
            this.dispose();
        }
    }

    void dispose() {
        Observable<ConnectionStatus> s = this.state;
        if (s != null) {
            this.state = null;
            s.removeListener((Listener)this);
        }
    }
}

